/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteRenderingMojo;
import org.codehaus.plexus.util.IOUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.NotFoundHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class SiteRunMojo
extends AbstractSiteRenderingMojo {
    private File tempWebappDirectory;
    private int port;
    private static final int MAX_IDLE_TIME = 30000;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Server server = new Server();
        server.setStopAtShutdown(true);
        Connector defaultConnector = this.getDefaultConnector();
        server.setConnectors(new Connector[]{defaultConnector});
        WebAppContext webapp = this.createWebApplication();
        webapp.setServer(server);
        NotFoundHandler notFoundHandler = new NotFoundHandler();
        notFoundHandler.setServer(server);
        Handler[] handlers = new Handler[]{webapp, notFoundHandler};
        server.setHandlers(handlers);
        this.getLog().info((CharSequence)"Starting Jetty on http://localhost:8080/");
        try {
            server.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing Jetty", e);
        }
        try {
            server.getThreadPool().join();
        }
        catch (InterruptedException e) {
            this.getLog().warn((CharSequence)"Jetty was interrupted", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebAppContext createWebApplication() throws MojoExecutionException {
        File webXml = new File(this.tempWebappDirectory, "WEB-INF/web.xml");
        webXml.getParentFile().mkdirs();
        InputStream inStream = null;
        FileOutputStream outStream = null;
        inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/webapp/web.xml");
        outStream = new FileOutputStream(webXml);
        IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
        IOUtil.close((OutputStream)outStream);
        IOUtil.close((InputStream)inStream);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setResourceBase(this.tempWebappDirectory.getAbsolutePath());
        webapp.setAttribute("siteRenderer", (Object)this.siteRenderer);
        List filteredReports = this.filterReports(this.reports);
        List localesList = this.getAvailableLocales();
        Locale defaultLocale = (Locale)localesList.get(0);
        Locale.setDefault(defaultLocale);
        try {
            Locale locale = Locale.getDefault();
            SiteRenderingContext context = this.createSiteRenderingContext(locale);
            webapp.setAttribute("context", (Object)context);
            Map documents = this.locateDocuments(context, filteredReports, locale);
            webapp.setAttribute("documents", (Object)documents);
            webapp.setAttribute("generatedSiteDirectory", (Object)this.generatedSiteDirectory);
            this.siteRenderer.copyResources(context, new File(this.siteDirectory, "resources"), this.tempWebappDirectory);
            return webapp;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to set up webapp", e);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(outStream);
                IOUtil.close((InputStream)inStream);
                throw throwable;
            }
        }
    }

    private Connector getDefaultConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setMaxIdleTime(30000L);
        return connector;
    }

    public void setTempWebappDirectory(File tempWebappDirectory) {
        this.tempWebappDirectory = tempWebappDirectory;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

