/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.pmd.model.CpdErrorDetail;
import org.apache.maven.plugins.pmd.model.Duplication;
import org.apache.maven.plugins.pmd.model.io.xpp3.CpdXpp3Reader;
import org.apache.maven.reporting.MavenReportException;

public class CpdResult {
    private final List<Duplication> duplications = new ArrayList<Duplication>();

    public CpdResult(File report, String encoding) throws MavenReportException {
        this.loadResult(report, encoding);
    }

    public List<Duplication> getDuplications() {
        return this.duplications;
    }

    public boolean hasDuplications() {
        return !this.duplications.isEmpty();
    }

    private void loadResult(File report, String encoding) throws MavenReportException {
        try (InputStreamReader reader1 = new InputStreamReader((InputStream)new FileInputStream(report), encoding);){
            CpdXpp3Reader reader = new CpdXpp3Reader();
            CpdErrorDetail details = reader.read(reader1, false);
            this.duplications.addAll(details.getDuplications());
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }
}

