/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jarsigner.AbstractJarsignerMojo;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE)
public class JarsignerSignMojo
extends AbstractJarsignerMojo {
    @Parameter(property="jarsigner.storepass")
    private String storepass;
    @Parameter(property="jarsigner.keypass")
    private String keypass;
    @Parameter(property="jarsigner.sigfile")
    private String sigfile;
    @Parameter(property="jarsigner.storetype")
    private String storetype;
    @Parameter(property="jarsigner.providerName")
    private String providerName;
    @Parameter(property="jarsigner.providerClass")
    private String providerClass;
    @Parameter(property="jarsigner.providerArg")
    private String providerArg;
    @Parameter(property="jarsigner.alias", required=true)
    private String alias;
    @Parameter(property="jarsigner.removeExistingSignatures", defaultValue="false")
    private boolean removeExistingSignatures;
    @Parameter(property="jarsigner.tsa")
    private String tsa;
    @Parameter(property="jarsigner.tsacert")
    private String tsacert;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;

    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo;
        String string = commandLineInfo = commandLine != null ? commandLine.toString() : null;
        if (commandLineInfo != null) {
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        }
        return commandLineInfo;
    }

    protected void preProcessArchive(File archive) throws MojoExecutionException {
        if (this.removeExistingSignatures) {
            try {
                JarSignerUtil.unsignArchive((File)archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to unsign archive " + archive + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    protected JarSignerRequest createRequest(File archive) throws MojoExecutionException {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setAlias(this.alias);
        request.setProviderArg(this.providerArg);
        request.setProviderClass(this.providerClass);
        request.setProviderName(this.providerName);
        request.setSigfile(this.sigfile);
        request.setStoretype(this.storetype);
        request.setTsaLocation(this.tsa);
        request.setTsaAlias(this.tsacert);
        try {
            request.setKeypass(this.securityDispatcher.decrypt(this.keypass));
            request.setStorepass(this.securityDispatcher.decrypt(this.storepass));
        }
        catch (SecDispatcherException e) {
            this.getLog().error((CharSequence)("error using security dispatcher: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("error using security dispatcher: " + e.getMessage(), (Exception)((Object)e));
        }
        return request;
    }
}

