/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="installAtEnd")
    private boolean installAtEnd;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false", property="allowIncompleteProjects")
    private boolean allowIncompleteProjects;
    private static final String INSTALL_PROCESSED_MARKER = InstallMojo.class.getName() + ".processed";
    private final Predicate<MavenProject> hasMavenInstallPluginExecution = rp -> this.hasExecution(rp.getPlugin("org.apache.maven.plugins:maven-install-plugin"));
    private final Predicate<PluginExecution> havingGoals = pe -> !pe.getGoals().isEmpty();
    private final Predicate<PluginExecution> nonePhase = pe -> !"none".equalsIgnoreCase(pe.getPhase());

    private void putState(State state) {
        this.getPluginContext().put(INSTALL_PROCESSED_MARKER, state.name());
    }

    private State getState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return State.valueOf((String)pluginContext.get(INSTALL_PROCESSED_MARKER));
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(INSTALL_PROCESSED_MARKER);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
            this.putState(State.SKIPPED);
        } else if (this.installAtEnd) {
            this.getLog().info((CharSequence)("Deferring install for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
            this.putState(State.TO_BE_INSTALLED);
        } else {
            InstallRequest request = new InstallRequest();
            this.processProject(this.project, request);
            this.installProject(request);
            this.putState(State.INSTALLED);
        }
        List<MavenProject> allProjectsUsingPlugin = this.getAllProjectsUsingPlugin();
        if (this.allProjectsMarked(allProjectsUsingPlugin)) {
            InstallRequest request = new InstallRequest();
            for (MavenProject reactorProject : allProjectsUsingPlugin) {
                State state = this.getState(reactorProject);
                if (state != State.TO_BE_INSTALLED) continue;
                this.processProject(reactorProject, request);
            }
            this.installProject(request);
        }
    }

    private boolean allProjectsMarked(List<MavenProject> allProjectsUsingPlugin) {
        return allProjectsUsingPlugin.stream().allMatch(this::hasState);
    }

    private List<MavenProject> getAllProjectsUsingPlugin() {
        return this.session.getProjects().stream().filter(this.hasMavenInstallPluginExecution).collect(Collectors.toList());
    }

    private boolean hasExecution(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return plugin.getExecutions().stream().filter(this.havingGoals).anyMatch(this.nonePhase);
    }

    private void installProject(InstallRequest request) throws MojoExecutionException {
        try {
            this.repositorySystem.install(this.session.getRepositorySession(), request);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processProject(MavenProject project, InstallRequest request) throws MojoExecutionException {
        boolean isIncomplete;
        Artifact projectArtifact;
        Artifact pomArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)new ProjectArtifact(project));
        if (ArtifactIdUtils.equalsId((Artifact)pomArtifact, (Artifact)(projectArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact())))) {
            if (this.isFile(projectArtifact.getFile())) {
                pomArtifact = projectArtifact;
            }
            projectArtifact = null;
        }
        if (!this.isFile(pomArtifact.getFile())) {
            throw new MojoExecutionException("The POM for project " + project.getArtifactId() + " could not be attached");
        }
        request.addArtifact(pomArtifact);
        boolean bl = isIncomplete = projectArtifact != null && !this.isFile(projectArtifact.getFile());
        if (projectArtifact != null) {
            if (!isIncomplete) {
                request.addArtifact(projectArtifact);
            } else {
                if (project.getAttachedArtifacts().isEmpty()) throw new MojoExecutionException("The packaging plugin for project " + project.getArtifactId() + " did not assign a file to the build artifact");
                if (!this.allowIncompleteProjects) throw new MojoExecutionException("The packaging plugin for project " + project.getArtifactId() + " did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                this.getLog().warn((CharSequence)"");
                this.getLog().warn((CharSequence)("The packaging plugin for project " + project.getArtifactId() + " did not assign"));
                this.getLog().warn((CharSequence)"a main file to the project but it has attachments. Change packaging to 'pom'.");
                this.getLog().warn((CharSequence)"");
                this.getLog().warn((CharSequence)"Incomplete projects like this will fail in future Maven versions!");
                this.getLog().warn((CharSequence)"");
            }
        }
        for (org.apache.maven.artifact.Artifact attached : project.getAttachedArtifacts()) {
            this.getLog().debug((CharSequence)("Attaching for install: " + attached.getId()));
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)attached));
        }
    }

    private boolean isFile(File file) {
        return file != null && file.isFile();
    }

    private static enum State {
        SKIPPED,
        INSTALLED,
        TO_BE_INSTALLED;

    }
}

