/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseOSGiManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponent15Writer;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponentWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpFacetsWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpmodulesWriter;
import org.apache.maven.plugin.ide.AbstractIdeSupportMojo;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class EclipsePlugin
extends AbstractIdeSupportMojo {
    private static final String NATURE_WST_FACET_CORE_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver";
    private static final String BUILDER_WST_VALIDATION = "org.eclipse.wst.validation.validationbuilder";
    private static final String BUILDER_JDT_CORE_JAVA = "org.eclipse.jdt.core.javabuilder";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilder";
    private static final String BUILDER_WST_FACET = "org.eclipse.wst.common.project.facet.core.builder";
    private static final String BUILDER_PDE_MANIFEST = "org.eclipse.pde.ManifestBuilder";
    private static final String BUILDER_PDE_SCHEMA = "org.eclipse.pde.SchemaBuilder";
    private static final String NATURE_WST_MODULE_CORE_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String NATURE_JDT_CORE_JAVA = "org.eclipse.jdt.core.javanature";
    private static final String NATURE_JEM_WORKBENCH_JAVA_EMF = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String NATURE_PDE_PLUGIN = "org.eclipse.pde.PluginNature";
    protected static final String COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    protected static final String REQUIRED_PLUGINS_CONTAINER = "org.eclipse.pde.core.requiredPlugins";
    public static final String[] WTP_SUPPORTED_VERSIONS = new String[]{"1.0", "1.5", "R7", "none"};
    private static final String POM_ELT_ARTIFACT_ID = "artifactId";
    private static final String POM_ELT_GROUP_ID = "groupId";
    private List projectnatures;
    private List additionalProjectnatures;
    private Map additionalProjectFacets;
    private List buildcommands;
    private List additionalBuildcommands;
    private List classpathContainers;
    private boolean eclipseDownloadSources;
    private File eclipseProjectDir;
    private boolean useProjectReferences;
    private File buildOutputDirectory;
    private String wtpversion;
    private String wtpContextName;
    private boolean pde;
    private File manifest;
    private EclipseConfigFile[] additionalConfig;
    private boolean addVersionToProjectName;
    private boolean addGroupIdToProjectName;
    private String projectNameTemplate;
    private float wtpVersionFloat;
    private boolean isJavaProject;

    protected boolean isJavaProject() {
        return this.isJavaProject;
    }

    protected boolean isPdeProject() {
        return this.pde;
    }

    public List getBuildcommands() {
        return this.buildcommands;
    }

    public void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    public File getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public void setBuildOutputDirectory(File buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public List getClasspathContainers() {
        return this.classpathContainers;
    }

    public void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    public File getEclipseProjectDir() {
        return this.eclipseProjectDir;
    }

    public void setEclipseProjectDir(File eclipseProjectDir) {
        this.eclipseProjectDir = eclipseProjectDir;
    }

    public List getProjectnatures() {
        return this.projectnatures;
    }

    public void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    public boolean getUseProjectReferences() {
        return this.useProjectReferences;
    }

    public void setUseProjectReferences(boolean useProjectReferences) {
        this.useProjectReferences = useProjectReferences;
    }

    public String getWtpversion() {
        return this.wtpversion;
    }

    public void setWtpversion(String wtpversion) {
        this.wtpversion = wtpversion;
    }

    public List getAdditionalBuildcommands() {
        return this.additionalBuildcommands;
    }

    public void setAdditionalBuildcommands(List additionalBuildcommands) {
        this.additionalBuildcommands = additionalBuildcommands;
    }

    public List getAdditionalProjectnatures() {
        return this.additionalProjectnatures;
    }

    public void setAdditionalProjectnatures(List additionalProjectnatures) {
        this.additionalProjectnatures = additionalProjectnatures;
    }

    public boolean isAddVersionToProjectName() {
        return this.addVersionToProjectName;
    }

    public void setAddVersionToProjectName(boolean addVersionToProjectName) {
        this.addVersionToProjectName = addVersionToProjectName;
    }

    public boolean isAddGroupIdToProjectName() {
        return this.addGroupIdToProjectName;
    }

    public void setAddGroupIdToProjectName(boolean addGroupIdToProjectName) {
        this.addGroupIdToProjectName = addGroupIdToProjectName;
    }

    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    public void setProjectNameTemplate(String projectNameTemplate) {
        this.projectNameTemplate = projectNameTemplate;
    }

    public boolean setup() throws MojoExecutionException {
        boolean ready = true;
        this.checkDeprecations();
        ready = this.validate();
        String packaging = this.executedProject.getPackaging();
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        this.isJavaProject = this.pde || "java".equals(artifactHandler.getLanguage()) && !"ear".equals(packaging);
        this.setupExtras();
        this.parseConfigurationOptions();
        if (this.projectnatures == null) {
            this.fillDefaultNatures(packaging);
        }
        if (this.additionalProjectnatures != null) {
            this.projectnatures.addAll(this.additionalProjectnatures);
        }
        if (this.buildcommands == null) {
            this.fillDefaultBuilders(packaging);
        } else {
            this.convertBuildCommandList(this.buildcommands);
        }
        if (this.additionalBuildcommands != null) {
            this.convertBuildCommandList(this.additionalBuildcommands);
            this.buildcommands.addAll(this.additionalBuildcommands);
        }
        if (this.classpathContainers == null) {
            this.fillDefaultClasspathContainers(packaging);
        } else {
            this.verifyClasspathContainerListIsComplete();
        }
        return ready;
    }

    protected void convertBuildCommandList(List commands) {
        if (commands != null) {
            ListIterator i = commands.listIterator();
            while (i.hasNext()) {
                Object command = i.next();
                if (!(command instanceof String)) continue;
                command = new BuildCommand((String)command);
                i.set(command);
            }
        }
    }

    private void parseConfigurationOptions() {
        if ("R7".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 0.7f;
        } else if ("1.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.0f;
        } else if ("1.5".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.5f;
        }
        if (!"none".equalsIgnoreCase(this.wtpversion)) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wtpversion", this.wtpversion));
        }
    }

    protected void setupExtras() throws MojoExecutionException {
    }

    protected void verifyClasspathContainerListIsComplete() {
        if (!this.classpathContainers.contains(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER)) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.missingjrecontainer"));
            this.classpathContainers.add(0, COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        }
    }

    private boolean validate() throws MojoExecutionException {
        if (Arrays.binarySearch(WTP_SUPPORTED_VERSIONS, this.wtpversion) < 0) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.unsupportedwtp", new Object[]{this.wtpversion, StringUtils.join((Object[])WTP_SUPPORTED_VERSIONS, (String)" ")}));
        }
        String packaging = this.executedProject.getPackaging();
        this.assertNotEmpty(this.executedProject.getGroupId(), POM_ELT_GROUP_ID);
        this.assertNotEmpty(this.executedProject.getArtifactId(), POM_ELT_ARTIFACT_ID);
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingpom"));
        }
        if ("pom".equals(packaging) && this.eclipseProjectDir == null) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return false;
        }
        if ("eclipse-plugin".equals(packaging)) {
            this.pde = true;
        }
        if (this.eclipseProjectDir == null) {
            this.eclipseProjectDir = this.executedProject.getFile().getParentFile();
        }
        if (!this.eclipseProjectDir.exists() && !this.eclipseProjectDir.mkdirs()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
        }
        if (!this.eclipseProjectDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.eclipseProjectDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.notadir", this.eclipseProjectDir));
            }
            this.eclipseProjectDir = new File(this.eclipseProjectDir, this.executedProject.getArtifactId());
            if (!this.eclipseProjectDir.isDirectory() && !this.eclipseProjectDir.mkdirs()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
            }
        }
        this.validateExtras();
        return true;
    }

    protected void validateExtras() {
    }

    private void checkDeprecations() {
        if (this.eclipseDownloadSources) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.deprecatedpar", new Object[]{"eclipse.downloadSources", "downloadSources"}));
            this.downloadSources = true;
        }
        this.checkExtraDeprecations();
    }

    protected void checkExtraDeprecations() {
    }

    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        EclipseWriterConfig config = this.createEclipseWriterConfig(deps);
        this.writeExtraConfiguration(config);
        if (this.wtpVersionFloat == 0.7f) {
            new EclipseWtpmodulesWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat >= 1.0f) {
            new EclipseWtpFacetsWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat == 1.0f) {
            new EclipseWtpComponentWriter().init(this.getLog(), config).write();
        }
        if ((double)this.wtpVersionFloat >= 1.5) {
            new EclipseWtpComponent15Writer().init(this.getLog(), config).write();
        }
        new EclipseSettingsWriter().init(this.getLog(), config).write();
        if (this.isJavaProject) {
            new EclipseClasspathWriter().init(this.getLog(), config).write();
        }
        if (this.pde) {
            this.getLog().info((CharSequence)"The Maven Eclipse plugin runs in 'pde'-mode.");
            new EclipseOSGiManifestWriter().init(this.getLog(), config).write();
        }
        new EclipseProjectWriter().init(this.getLog(), config).write();
        if (this.additionalConfig != null) {
            for (int j = 0; j < this.additionalConfig.length; ++j) {
                EclipseConfigFile file = this.additionalConfig[j];
                File projectRelativeFile = new File(this.eclipseProjectDir, file.getName());
                if (projectRelativeFile.isDirectory()) {
                    this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.foundadir", projectRelativeFile.getAbsolutePath()));
                }
                try {
                    projectRelativeFile.getParentFile().mkdirs();
                    FileUtils.fileWrite((String)projectRelativeFile.getAbsolutePath(), (String)file.getContent());
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", projectRelativeFile.getAbsolutePath()));
                }
            }
        }
        this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wrote", new Object[]{config.getEclipseProjectName(), this.eclipseProjectDir.getAbsolutePath()}));
    }

    protected EclipseWriterConfig createEclipseWriterConfig(IdeDependency[] deps) throws MojoExecutionException {
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        EclipseSourceDir[] sourceDirs = this.buildDirectoryList(this.executedProject, this.eclipseProjectDir, this.buildOutputDirectory);
        EclipseWriterConfig config = new EclipseWriterConfig();
        config.setProjectNameTemplate(this.calculateProjectNameTemplate());
        String projectName = IdeUtils.getProjectName(config.getProjectNameTemplate(), this.project);
        config.setEclipseProjectName(projectName);
        LinkedHashSet<BuildCommand> convertedBuildCommands = new LinkedHashSet<BuildCommand>();
        if (this.buildcommands != null) {
            Iterator it = this.buildcommands.iterator();
            while (it.hasNext()) {
                Object cmd = it.next();
                if (cmd instanceof BuildCommand) {
                    convertedBuildCommands.add((BuildCommand)cmd);
                    continue;
                }
                convertedBuildCommands.add(new BuildCommand((String)cmd));
            }
        }
        config.setBuildCommands(new LinkedList(convertedBuildCommands));
        config.setBuildOutputDirectory(this.buildOutputDirectory);
        config.setClasspathContainers(this.classpathContainers);
        config.setDeps(deps);
        config.setEclipseProjectDirectory(this.eclipseProjectDir);
        config.setLocalRepository(this.localRepository);
        config.setManifestFile(this.manifest);
        config.setPde(this.pde);
        config.setProject(this.project);
        config.setProjectBaseDir(projectBaseDir);
        config.setProjectnatures(this.projectnatures);
        config.setProjectFacets(this.additionalProjectFacets);
        config.setSourceDirs(sourceDirs);
        config.setAddVersionToProjectName(this.isAddVersionToProjectName());
        config.setContextName(this.wtpContextName);
        return config;
    }

    protected void writeExtraConfiguration(EclipseWriterConfig config) throws MojoExecutionException {
    }

    private void assertNotEmpty(String string, String elementName) throws MojoExecutionException {
        if (string == null) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingelement", elementName));
        }
    }

    protected void fillDefaultNatures(String packaging) {
        this.projectnatures = new ArrayList();
        if (this.wtpVersionFloat >= 1.0f) {
            this.projectnatures.add(NATURE_WST_FACET_CORE_NATURE);
        }
        if (this.isJavaProject) {
            this.projectnatures.add(NATURE_JDT_CORE_JAVA);
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.projectnatures.add(NATURE_WST_MODULE_CORE_NATURE);
            if (this.isJavaProject) {
                this.projectnatures.add(NATURE_JEM_WORKBENCH_JAVA_EMF);
            }
        }
        if (this.pde) {
            this.projectnatures.add(NATURE_PDE_PLUGIN);
        }
    }

    protected void fillDefaultClasspathContainers(String packaging) {
        this.classpathContainers = new ArrayList();
        this.classpathContainers.add(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        if (this.pde) {
            this.classpathContainers.add(REQUIRED_PLUGINS_CONTAINER);
        }
    }

    protected void fillDefaultBuilders(String packaging) {
        this.buildcommands = new ArrayList();
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL));
        }
        if (this.isJavaProject) {
            this.buildcommands.add(new BuildCommand(BUILDER_JDT_CORE_JAVA));
        }
        if (this.wtpVersionFloat >= 1.5f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_FACET));
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_VALIDATION));
        }
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER));
        }
        if (this.pde) {
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_MANIFEST));
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_SCHEMA));
        }
    }

    public EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, File buildOutputDirectory) throws MojoExecutionException {
        File projectBaseDir = project.getFile().getParentFile();
        TreeSet directories = new TreeSet();
        this.extractSourceDirs(directories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        String relativeOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, buildOutputDirectory, false);
        this.extractResourceDirs(directories, project.getBuild().getResources(), project, basedir, projectBaseDir, false, relativeOutput);
        String testOutput = null;
        boolean useStandardOutputDir = buildOutputDirectory.equals(new File(project.getBuild().getOutputDirectory()));
        if (useStandardOutputDir) {
            this.getLog().debug((CharSequence)("testOutput toRelativeAndFixSeparator " + projectBaseDir + " , " + project.getBuild().getTestOutputDirectory()));
            testOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, new File(project.getBuild().getTestOutputDirectory()), false);
            this.getLog().debug((CharSequence)("testOutput after toRelative : " + testOutput));
        }
        this.extractSourceDirs(directories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        this.extractResourceDirs(directories, project.getBuild().getTestResources(), project, basedir, projectBaseDir, true, testOutput);
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            File sourceRootFile = new File((String)it.next());
            if (!sourceRootFile.isDirectory()) continue;
            String sourceRoot = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRootFile, !projectBaseDir.equals(basedir));
            directories.add(new EclipseSourceDir(sourceRoot, output, false, test, null, null, false));
        }
    }

    void extractResourceDirs(Set directories, List resources, MavenProject project, File basedir, File workspaceProjectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            File resourceDirectory;
            Resource resource = (Resource)it.next();
            this.getLog().debug((CharSequence)("Processing resource dir: " + resource.getDirectory()));
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                includePattern = StringUtils.join(resource.getIncludes().iterator(), (String)"|");
            }
            if (resource.getExcludes().size() != 0) {
                excludePattern = StringUtils.join(resource.getExcludes().iterator(), (String)"|");
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) {
                this.getLog().debug((CharSequence)("Resource dir: " + resourceDirectory + " either missing or not a directory."));
                continue;
            }
            String resourceDir = IdeUtils.toRelativeAndFixSeparator(workspaceProjectBaseDir, resourceDirectory, !workspaceProjectBaseDir.equals(basedir));
            String thisOutput = output;
            if (thisOutput != null) {
                File outputFile = new File(thisOutput);
                if (!outputFile.isAbsolute()) {
                    outputFile = new File(workspaceProjectBaseDir, thisOutput);
                }
                outputFile.mkdirs();
                if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                    outputFile = new File(outputFile, resource.getTargetPath());
                    outputFile.mkdirs();
                }
                this.getLog().debug((CharSequence)("Making relative and fixing separator: { " + workspaceProjectBaseDir + ", " + outputFile + ", false }."));
                thisOutput = IdeUtils.toRelativeAndFixSeparator(workspaceProjectBaseDir, outputFile, false);
            }
            this.getLog().debug((CharSequence)("Adding eclipse source dir: { " + resourceDir + ", " + thisOutput + ", true, " + test + ", " + includePattern + ", " + excludePattern + " }."));
            directories.add(new EclipseSourceDir(resourceDir, thisOutput, true, test, includePattern, excludePattern, resource.isFiltering()));
        }
    }

    private String calculateProjectNameTemplate() {
        if (this.getProjectNameTemplate() != null) {
            if (this.isAddVersionToProjectName() || this.isAddGroupIdToProjectName()) {
                this.getLog().warn((CharSequence)"projectNameTemplate definition overrides addVersionToProjectName or addGroupIdToProjectName");
            }
            return this.getProjectNameTemplate();
        }
        if (this.isAddVersionToProjectName() && this.isAddGroupIdToProjectName()) {
            return "[groupId].[artifactId]-[version]";
        }
        if (this.isAddVersionToProjectName()) {
            return "[artifactId]-[version]";
        }
        if (this.isAddGroupIdToProjectName()) {
            return "[groupId].[artifactId]";
        }
        return "[artifactId]";
    }
}

