/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.ear.AbstractEarModule;
import org.apache.maven.plugins.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JarModule
extends AbstractEarModule {
    public static final String DEFAULT_ARTIFACT_TYPE = "jar";
    private Boolean includeInApplicationXml = Boolean.FALSE;

    public JarModule() {
        this.type = DEFAULT_ARTIFACT_TYPE;
        this.classPathItem = true;
    }

    public JarModule(Artifact a, String defaultLibBundleDir, Boolean includeInApplicationXml) {
        super(a);
        this.setLibBundleDir(defaultLibBundleDir);
        this.includeInApplicationXml = includeInApplicationXml;
        this.classPathItem = true;
    }

    @Override
    public void appendModule(XMLWriter writer, String version, Boolean generateId) {
        if (this.includeInApplicationXml.booleanValue()) {
            this.startModuleElement(writer, generateId);
            writer.startElement("java");
            writer.writeText(this.getUri());
            writer.endElement();
            this.writeAltDeploymentDescriptor(writer, version);
            writer.endElement();
        }
    }

    @Override
    public void resolveArtifact(Set<Artifact> artifacts) throws EarPluginException, MojoFailureException {
        super.resolveArtifact(artifacts);
        this.setLibBundleDir(this.earExecutionContext.getDefaultLibBundleDir());
    }

    private void setLibBundleDir(String defaultLibBundleDir) {
        if (defaultLibBundleDir != null && this.bundleDir == null) {
            this.bundleDir = defaultLibBundleDir;
        }
    }

    @Override
    public boolean changeManifestClasspath() {
        return false;
    }
}

