/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;

public class IssueUtils {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static List filterIssuesWithVersionPrefix(List issues, String prefix) throws MojoExecutionException {
        ArrayList<Issue> filteredIssues = new ArrayList<Issue>();
        boolean isFound = false;
        Issue issue = null;
        block0: for (int i = 0; i < issues.size(); ++i) {
            issue = (Issue)issues.get(i);
            if (issue.getFixVersions() == null) continue;
            for (int j = 0; j < issue.getFixVersions().size(); ++j) {
                String fixVersion = (String)issue.getFixVersions().get(j);
                if (prefix != null && !fixVersion.startsWith(prefix)) continue;
                isFound = true;
                filteredIssues.add(issue);
                continue block0;
            }
        }
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find any issues with a Fix Version prefix of '" + prefix + "' among the supplied issues.");
        }
        return filteredIssues;
    }

    public static List getIssuesForVersion(List issues, String version) throws MojoExecutionException {
        ArrayList<Issue> issuesForVersion = new ArrayList<Issue>();
        boolean isFound = false;
        Issue issue = null;
        String releaseVersion = version;
        if (version != null && version.endsWith(SNAPSHOT_SUFFIX)) {
            releaseVersion = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        for (int i = 0; i < issues.size(); ++i) {
            issue = (Issue)issues.get(i);
            if (issue.getFixVersions() == null || !issue.getFixVersions().contains(releaseVersion)) continue;
            isFound = true;
            issuesForVersion.add(issue);
        }
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find any issues for the version '" + releaseVersion + "' among the supplied issues.");
        }
        return issuesForVersion;
    }
}

