/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes a build extension to utilise.
 * 
 * @version $Revision$ $Date$
 */
public class Extension implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The group ID of the extension's artifact.
     */
    private String groupId;

    /**
     * The artifact ID of the extension.
     */
    private String artifactId;

    /**
     * The version of the extension.
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the artifact ID of the extension.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get the group ID of the extension's artifact.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get the version of the extension.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set the artifact ID of the extension.
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String ) 

    /**
     * Set the group ID of the extension's artifact.
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String ) 

    /**
     * Set the version of the extension.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String ) 


            
    /**
     * Gets the key of the extension. The key is used to merge extensions inherited from a parent with the extensions
     * of the current project.
     * 
     * @return The key of the extension, i.e. <code>groupId:artifactId</code>.
     */
    public String getKey()
    {
        return new StringBuffer( 128 ).append( getGroupId() ).append( ':' ).append( getArtifactId() ).toString();
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }

        if ( !( o instanceof Extension ) )
        {
            return false;
        }

        Extension e = (Extension) o;

        if ( !e.getArtifactId().equals( getArtifactId() ) )
        {
            return false;
        }
        else if ( !e.getGroupId().equals( getGroupId() ) )
        {
            return false;
        }
        else if ( e.getVersion() != null ? !e.getVersion().equals( getVersion() ) : getVersion() != null )
        {
            return false;
        }
        return true;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        int result = 17;
        result = 37 * result + ( getArtifactId() != null ? getArtifactId().hashCode() : 0 );
        result = 37 * result + ( getGroupId() != null ? getGroupId().hashCode() : 0 );
        result = 37 * result + ( getVersion() != null ? getVersion().hashCode() : 0 );
        return result;
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
