/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         The <code>&lt;CiManagement&gt;</code> element contains
 * informations required to the
 *         continuous integration system of the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class CiManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     *             
     *           
     */
    private String system;

    /**
     * URL for the continuous integration system used by the
     * project if it has a web
     *             interface.
     */
    private String url;

    /**
     * Field notifiers.
     */
    private java.util.List notifiers;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addNotifier.
     * 
     * @param notifier
     */
    public void addNotifier( Notifier notifier )
    {
        if ( !(notifier instanceof Notifier) )
        {
            throw new ClassCastException( "CiManagement.addNotifiers(notifier) parameter must be instanceof " + Notifier.class.getName() );
        }
        getNotifiers().add( notifier );
    } //-- void addNotifier( Notifier ) 

    /**
     * Method getNotifiers.
     * 
     * @return java.util.List
     */
    public java.util.List getNotifiers()
    {
        if ( this.notifiers == null )
        {
            this.notifiers = new java.util.ArrayList();
        }
    
        return this.notifiers;
    } //-- java.util.List getNotifiers() 

    /**
     * Get 
     *             
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     *             
     *           
     * 
     * @return String
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem() 

    /**
     * Get uRL for the continuous integration system used by the
     * project if it has a web
     *             interface.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method removeNotifier.
     * 
     * @param notifier
     */
    public void removeNotifier( Notifier notifier )
    {
        if ( !(notifier instanceof Notifier) )
        {
            throw new ClassCastException( "CiManagement.removeNotifiers(notifier) parameter must be instanceof " + Notifier.class.getName() );
        }
        getNotifiers().remove( notifier );
    } //-- void removeNotifier( Notifier ) 

    /**
     * Set configuration for notifying developers/users when a
     * build is unsuccessful,
     *             including user information and notification
     * mode.
     * 
     * @param notifiers
     */
    public void setNotifiers( java.util.List notifiers )
    {
        this.notifiers = notifiers;
    } //-- void setNotifiers( java.util.List ) 

    /**
     * Set 
     *             
     *             The name of the continuous integration system,
     * e.g. <code>continuum</code>.
     *             
     *           
     * 
     * @param system
     */
    public void setSystem( String system )
    {
        this.system = system;
    } //-- void setSystem( String ) 

    /**
     * Set uRL for the continuous integration system used by the
     * project if it has a web
     *             interface.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
