/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;

public class JavaFileImpl
extends JavaFile {
    public JavaFileImpl(Path path, String encoding) throws IOException {
        super(path, encoding);
        this.addImportType(new ImportType("java.lang.*"));
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        StreamTokenizer stok = null;
        try (Reader reader = this.getReader();){
            stok = this.getTokenizer(reader);
            this.parseRecursive("", stok);
        }
        finally {
            stok = null;
        }
    }

    private void parseRecursive(String nestedPrefix, StreamTokenizer stok) throws IOException {
        int openBracesCount = 0;
        while (stok.nextToken() != -1) {
            if (stok.sval == null) {
                if (stok.ttype == 123) {
                    ++openBracesCount;
                    continue;
                }
                if (stok.ttype != 125 || --openBracesCount != 0) continue;
                return;
            }
            if ("package".equals(stok.sval) && stok.ttype != 34) {
                stok.nextToken();
                this.setPackageType(new PackageType(stok.sval));
            }
            if ("import".equals(stok.sval) && stok.ttype != 34) {
                stok.nextToken();
                String name = stok.sval;
                if (name.charAt(name.length() - 1) == '.') {
                    name = name + '*';
                }
                this.addImportType(new ImportType(name));
            }
            if (!"class".equals(stok.sval) && !"interface".equals(stok.sval) && !"enum".equals(stok.sval) || stok.ttype == 34) continue;
            stok.nextToken();
            this.addClassType(new ClassType(nestedPrefix + stok.sval, JavaFileImpl.getFilenameWithoutPathOrExtension(this.getPath())));
            this.parseRecursive(nestedPrefix + stok.sval + ".", stok);
        }
    }

    private StreamTokenizer getTokenizer(Reader reader) {
        StreamTokenizer stok = new StreamTokenizer(reader);
        stok.commentChar(42);
        stok.wordChars(95, 95);
        stok.slashStarComments(true);
        stok.slashSlashComments(true);
        return stok;
    }

    private Reader getReader() throws IOException {
        if (Files.notExists(this.getPath(), new LinkOption[0])) {
            throw new IOException(this.getPath() + " does not exist!");
        }
        if (this.getEncoding() != null) {
            return new InputStreamReader((InputStream)new FileInputStream(this.getPath().toFile()), this.getEncoding());
        }
        return new FileReader(this.getPath().toFile());
    }
}

