/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.codehaus.plexus.util.IOUtil;

public class FoUtils {
    public static void convertFO2PDF(File fo, File pdf, String resourceDir) throws TransformerException {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        foUserAgent.setBaseURL(FoUtils.getBaseURL(fo, resourceDir));
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(pdf));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            StreamSource src = new StreamSource(fo);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            Transformer transformer = null;
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new TransformerException(e);
            }
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            try {
                throw new TransformerException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)out);
    }

    private static String getBaseURL(File fo, String resourceDir) {
        String url = null;
        url = resourceDir == null ? "file:///" + fo.getParent() + "/" : "file:///" + resourceDir + "/";
        return url;
    }

    private FoUtils() {
    }
}

