/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck.validation;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.doxia.linkcheck.HttpBean;
import org.apache.maven.doxia.linkcheck.validation.Anchors;
import org.apache.maven.doxia.linkcheck.validation.HTTPLinkValidationResult;
import org.apache.maven.doxia.linkcheck.validation.HTTPLinkValidator;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationItem;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationResult;
import org.codehaus.plexus.util.StringUtils;

public final class OnlineHTTPLinkValidator
extends HTTPLinkValidator {
    private static final Log LOG = LogFactory.getLog((Class)OnlineHTTPLinkValidator.class);
    private static final int MAX_NB_REDIRECT = 10;
    private static final String GET_METHOD = "get";
    private static final String HEAD_METHOD = "head";
    private HttpBean http;
    private String baseURL;
    private transient HttpClient cl;

    public OnlineHTTPLinkValidator() {
        this(new HttpBean());
    }

    public OnlineHTTPLinkValidator(HttpBean bean) {
        if (bean == null) {
            bean = new HttpBean();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will use method : [" + bean.getMethod() + "]"));
        }
        this.http = bean;
        this.initHttpClient();
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        String msg;
        if (this.cl == null) {
            this.initHttpClient();
        }
        if (this.http.getHttpClientParameters() != null) {
            Iterator<Map.Entry<Object, Object>> it = this.http.getHttpClientParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                if (entry.getValue() == null) continue;
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        System.setProperty("http.useragent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        this.cl.getParams().setParameter("http.useragent", (Object)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        String link = lvi.getLink();
        String anchor = "";
        int idx = link.indexOf(35);
        if (idx != -1) {
            anchor = link.substring(idx + 1);
            link = link.substring(0, idx);
        }
        try {
            if (link.startsWith("/")) {
                if (this.getBaseURL() == null) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Cannot check link [" + link + "] in page [" + lvi.getSource() + "], as no base URL has been set!"));
                    }
                    LinkValidationResult linkValidationResult = new LinkValidationResult(2, false, "No base URL specified");
                    return linkValidationResult;
                }
                link = this.getBaseURL() + link;
            }
            HttpMethod hm = null;
            try {
                hm = this.checkLink(link, 0);
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received: [" + t + "] for [" + link + "] in page [" + lvi.getSource() + "]"), t);
                }
                LinkValidationResult entry = new LinkValidationResult(1, false, t.getClass().getName() + " : " + t.getMessage());
                System.getProperties().remove("http.useragent");
                if (this.http.getHttpClientParameters() != null) {
                    Iterator<Map.Entry<Object, Object>> it = this.http.getHttpClientParameters().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Object, Object> entry2 = it.next();
                        if (entry2.getValue() == null) continue;
                        System.getProperties().remove(entry2.getKey().toString());
                    }
                }
                return entry;
            }
            if (hm == null) {
                LinkValidationResult t = new LinkValidationResult(1, false, "Cannot retreive HTTP Status");
                return t;
            }
            if (hm.getStatusCode() == 200) {
                Object content;
                if (anchor.length() > 0 && !Anchors.matchesAnchor((String)(content = hm.getResponseBodyAsString()), anchor)) {
                    HTTPLinkValidationResult it = new HTTPLinkValidationResult(3, false, "Missing anchor '" + anchor + "'");
                    return it;
                }
                content = new HTTPLinkValidationResult(3, true, hm.getStatusCode(), hm.getStatusText());
                return content;
            }
            msg = "Received: [" + hm.getStatusCode() + "] for [" + link + "] in page [" + lvi.getSource() + "]";
            if (hm.getStatusCode() == 301 || hm.getStatusCode() == 302 || hm.getStatusCode() == 307) {
                LOG.warn((Object)msg);
                HTTPLinkValidationResult hTTPLinkValidationResult = new HTTPLinkValidationResult(2, true, hm.getStatusCode(), hm.getStatusText());
                return hTTPLinkValidationResult;
            }
            LOG.debug((Object)msg);
            HTTPLinkValidationResult hTTPLinkValidationResult = new HTTPLinkValidationResult(1, false, hm.getStatusCode(), hm.getStatusText());
            return hTTPLinkValidationResult;
        }
        catch (Throwable t) {
            msg = "Received: [" + t + "] for [" + link + "] in page [" + lvi.getSource() + "]";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg, t);
            } else {
                LOG.error((Object)msg);
            }
            LinkValidationResult linkValidationResult = new LinkValidationResult(1, false, t.getMessage());
            return linkValidationResult;
        }
        finally {
            System.getProperties().remove("http.useragent");
            if (this.http.getHttpClientParameters() != null) {
                Iterator<Map.Entry<Object, Object>> it = this.http.getHttpClientParameters().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    if (entry.getValue() == null) continue;
                    System.getProperties().remove(entry.getKey().toString());
                }
            }
        }
    }

    private void initHttpClient() {
        LOG.debug((Object)"A new HttpClient instance is needed ...");
        this.cl = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (this.http.getTimeout() != 0) {
            this.cl.getHttpConnectionManager().getParams().setConnectionTimeout(this.http.getTimeout());
            this.cl.getHttpConnectionManager().getParams().setSoTimeout(this.http.getTimeout());
        }
        this.cl.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        HostConfiguration hc = new HostConfiguration();
        HttpState state = new HttpState();
        if (StringUtils.isNotEmpty((String)this.http.getProxyHost())) {
            hc.setProxy(this.http.getProxyHost(), this.http.getProxyPort());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Proxy Host:" + this.http.getProxyHost()));
                LOG.debug((Object)("Proxy Port:" + this.http.getProxyPort()));
            }
            if (StringUtils.isNotEmpty((String)this.http.getProxyUser()) && this.http.getProxyPassword() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Proxy User:" + this.http.getProxyUser()));
                }
                Object credentials = StringUtils.isNotEmpty((String)this.http.getProxyNtlmHost()) ? new NTCredentials(this.http.getProxyUser(), this.http.getProxyPassword(), this.http.getProxyNtlmHost(), this.http.getProxyNtlmDomain()) : new UsernamePasswordCredentials(this.http.getProxyUser(), this.http.getProxyPassword());
                state.setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
            }
        } else {
            LOG.debug((Object)"Not using a proxy");
        }
        this.cl.setHostConfiguration(hc);
        this.cl.setState(state);
        LOG.debug((Object)"New HttpClient instance created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMethod checkLink(String link, int nbRedirect) throws IOException {
        HeadMethod hm;
        int max;
        block23: {
            max = 10;
            if (this.http.getHttpClientParameters() != null && this.http.getHttpClientParameters().get("http.protocol.max-redirects") != null) {
                try {
                    max = Integer.valueOf(this.http.getHttpClientParameters().get("http.protocol.max-redirects").toString());
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block23;
                    LOG.warn((Object)"HttpClient parameter 'http.protocol.max-redirects' is not a number. Ignoring!");
                }
            }
        }
        if (nbRedirect > max) {
            throw new HttpException("Maximum number of redirections (" + max + ") exceeded");
        }
        if (HEAD_METHOD.equalsIgnoreCase(this.http.getMethod())) {
            hm = new HeadMethod(link);
        } else if (GET_METHOD.equalsIgnoreCase(this.http.getMethod())) {
            hm = new GetMethod(link);
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unsupported method: " + this.http.getMethod() + ", using 'get'."));
            }
            hm = new GetMethod(link);
        }
        hm.setFollowRedirects(this.http.isFollowRedirects());
        try {
            URL url = new URL(link);
            this.cl.getHostConfiguration().setHost(url.getHost(), url.getPort(), url.getProtocol());
            this.cl.executeMethod((HttpMethod)hm);
            StatusLine sl = hm.getStatusLine();
            if (sl == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Unknown error validating link : " + link));
                }
                HttpMethod httpMethod = null;
                return httpMethod;
            }
            if (hm.getStatusCode() == 301 || hm.getStatusCode() == 302 || hm.getStatusCode() == 307) {
                Header locationHeader = hm.getResponseHeader("location");
                if (locationHeader == null) {
                    LOG.error((Object)"Site sent redirect, but did not set Location header");
                    HeadMethod headMethod = hm;
                    return headMethod;
                }
                String newLink = locationHeader.getValue();
                if (!newLink.startsWith("http://") && !newLink.startsWith("https://")) {
                    if (newLink.startsWith("/")) {
                        URL oldUrl = new URL(link);
                        newLink = oldUrl.getProtocol() + "://" + oldUrl.getHost() + (oldUrl.getPort() > 0 ? ":" + oldUrl.getPort() : "") + newLink;
                    } else {
                        newLink = link + newLink;
                    }
                }
                HeadMethod oldHm = hm;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[" + link + "] is redirected to [" + newLink + "]"));
                }
                oldHm.releaseConnection();
                hm = this.checkLink(newLink, nbRedirect + 1);
                if (hm.getStatusCode() == 200 && nbRedirect == 0) {
                    HeadMethod headMethod = oldHm;
                    return headMethod;
                }
            }
        }
        finally {
            hm.releaseConnection();
        }
        return hm;
    }
}

