/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationItem;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationResult;
import org.apache.maven.doxia.linkcheck.validation.LinkValidator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public class LinkValidatorManager
implements Serializable {
    private static final long serialVersionUID = 2467928182206500945L;
    private static final Log LOG = LogFactory.getLog((Class)LinkValidatorManager.class);
    private List validators = new LinkedList();
    private String[] excludedLinks = new String[0];
    private Map cache = new HashMap();

    public List getValidators() {
        return this.validators;
    }

    public String[] getExcludedLinks() {
        return this.excludedLinks;
    }

    public void setExcludedLinks(String[] excl) {
        this.excludedLinks = excl;
    }

    public void addLinkValidator(LinkValidator lv) {
        this.validators.add(lv);
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        LinkValidationResult lvr;
        Object resourceKey;
        LinkValidator lv;
        LinkValidationResult cachedResult = this.getCachedResult(lvi);
        if (cachedResult != null) {
            return cachedResult;
        }
        for (int i = 0; i < this.excludedLinks.length; ++i) {
            if (this.excludedLinks[i] == null || !LinkValidatorManager.matchPattern(lvi.getLink(), this.excludedLinks[i])) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Excluded " + lvi.getLink()));
            }
            return new LinkValidationResult(3, false, "");
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            lv = (LinkValidator)iter.next();
            resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(lv.getClass().getName() + " - Checking link " + lvi.getLink()));
            }
            if ((lvr = lv.validateLink(lvi)).getStatus() == 0) continue;
            this.setCachedResult(resourceKey, lvr);
            return lvr;
        }
        lv = null;
        resourceKey = null;
        lvr = null;
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Unable to validate link : " + lvi.getLink()));
        }
        return new LinkValidationResult(4, false, "No validator found for this link");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadCache(File cacheFile) throws IOException {
        ObjectInputStream is;
        block9: {
            if (cacheFile == null) {
                LOG.debug((Object)"No cache file specified! Ignoring request to load.");
                return;
            }
            if (!cacheFile.exists()) {
                LOG.debug((Object)"Specified cache file does not exist! Ignoring request to load.");
                return;
            }
            if (cacheFile.isDirectory()) {
                LOG.debug((Object)"Cache file is a directory! Ignoring request to load.");
                return;
            }
            is = null;
            try {
                is = new ObjectInputStream(new FileInputStream(cacheFile));
                this.cache = (Map)is.readObject();
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)("Cache file loaded: " + cacheFile.getAbsolutePath()));
            }
            catch (InvalidClassException e) {
                LOG.warn((Object)"Your cache is incompatible with this version of linkcheck. It will be recreated.");
                IOUtil.close((InputStream)is);
            }
            catch (ClassNotFoundException e2) {
                block10: {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error((Object)("Unable to load the cache: " + cacheFile.getAbsolutePath()), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IOUtil.close(is);
                            throw throwable;
                        }
                    }
                }
                IOUtil.close((InputStream)is);
            }
        }
        IOUtil.close((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache(File cacheFile) throws IOException {
        Object resourceKey;
        if (cacheFile == null) {
            LOG.warn((Object)"No cache file specified! Ignoring request to store results.");
            return;
        }
        if (cacheFile.isDirectory()) {
            LOG.debug((Object)"Cache file is a directory! Ignoring request to load.");
            return;
        }
        HashMap persistentCache = new HashMap();
        Iterator iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            resourceKey = iter.next();
            if (!((LinkValidationResult)this.cache.get(resourceKey)).isPersistent()) continue;
            persistentCache.put(resourceKey, this.cache.get(resourceKey));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("[" + resourceKey + "] with result [" + this.cache.get(resourceKey) + "] is stored in the cache."));
        }
        File dir = cacheFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        ObjectOutputStream os = null;
        try {
            os = new ObjectOutputStream(new FileOutputStream(cacheFile));
            os.writeObject(persistentCache);
        }
        finally {
            persistentCache = null;
            iter = null;
            resourceKey = null;
            cacheFile = null;
            dir = null;
            IOUtil.close((OutputStream)os);
        }
    }

    public LinkValidationResult getCachedResult(LinkValidationItem lvi) {
        Object resourceKey;
        LinkValidator lv;
        Iterator iter = this.getValidators().iterator();
        while (iter.hasNext()) {
            lv = (LinkValidator)iter.next();
            resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null || !this.cache.containsKey(resourceKey)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The cache returns for [" + resourceKey + "] the result [" + this.cache.get(resourceKey) + "]."));
            }
            return (LinkValidationResult)this.cache.get(resourceKey);
        }
        lv = null;
        resourceKey = null;
        return null;
    }

    public void setCachedResult(Object resourceKey, LinkValidationResult lvr) {
        this.cache.put(resourceKey, lvr);
    }

    protected static boolean matchPattern(String link, String pattern) {
        String diff;
        if (StringUtils.isEmpty((String)pattern)) {
            return StringUtils.isEmpty((String)link);
        }
        if (pattern.indexOf(42) == -1) {
            if (pattern.endsWith("/")) {
                return link.indexOf(pattern.substring(0, pattern.lastIndexOf(47))) != -1;
            }
            return link.indexOf(pattern) != -1;
        }
        try {
            URI uri = new URI(link);
            if (uri.getScheme() != null && !pattern.startsWith(uri.getScheme())) {
                return false;
            }
        }
        catch (URISyntaxException ex) {
            LOG.debug((Object)("Trying to check link to illegal URI: " + link), (Throwable)ex);
        }
        if (pattern.matches("\\*+/?.*") && !link.startsWith("/") && !link.startsWith("./")) {
            link = "./" + link;
        }
        if ((diff = StringUtils.difference((String)link, (String)pattern)).startsWith("/")) {
            return SelectorUtils.match((String)pattern, (String)(link + "/"));
        }
        return SelectorUtils.match((String)pattern, (String)link);
    }
}

