/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.PriorityQueue;

public abstract class Lookup {
    public static final Comparator<CharSequence> CHARSEQUENCE_COMPARATOR = new CharSequenceComparator();

    public void build(Dictionary dict) throws IOException {
        BytesRefIterator it = dict.getWordsIterator();
        TermFreqIterator tfit = it instanceof TermFreqIterator ? (TermFreqIterator)it : new TermFreqIterator.TermFreqIteratorWrapper(it);
        this.build(tfit);
    }

    public abstract void build(TermFreqIterator var1) throws IOException;

    public abstract List<LookupResult> lookup(CharSequence var1, boolean var2, int var3);

    public abstract boolean store(OutputStream var1) throws IOException;

    public abstract boolean load(InputStream var1) throws IOException;

    public static final class LookupPriorityQueue
    extends PriorityQueue<LookupResult> {
        public LookupPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(LookupResult a, LookupResult b) {
            return a.value < b.value;
        }

        public LookupResult[] getResults() {
            int size = this.size();
            LookupResult[] res = new LookupResult[size];
            for (int i = size - 1; i >= 0; --i) {
                res[i] = (LookupResult)this.pop();
            }
            return res;
        }
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l1 = o1.length();
            int l2 = o2.length();
            int aStop = Math.min(l1, l2);
            for (int i = 0; i < aStop; ++i) {
                int diff = o1.charAt(i) - o2.charAt(i);
                if (diff == 0) continue;
                return diff;
            }
            return l1 - l2;
        }
    }

    public static final class LookupResult
    implements Comparable<LookupResult> {
        public final CharSequence key;
        public final long value;

        public LookupResult(CharSequence key, long value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "/" + this.value;
        }

        @Override
        public int compareTo(LookupResult o) {
            return CHARSEQUENCE_COMPARATOR.compare(this.key, o.key);
        }
    }
}

