/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public final class DocValuesRangeQuery
extends Query {
    private final String field;
    private final Object lowerVal;
    private final Object upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public static Query newLongRange(String field, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeQuery(field, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static Query newBytesRefRange(String field, BytesRef lowerVal, BytesRef upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeQuery(field, DocValuesRangeQuery.deepCopyOf(lowerVal), DocValuesRangeQuery.deepCopyOf(upperVal), includeLower, includeUpper);
    }

    private static BytesRef deepCopyOf(BytesRef b) {
        if (b == null) {
            return null;
        }
        return BytesRef.deepCopyOf((BytesRef)b);
    }

    private DocValuesRangeQuery(String field, Object lowerVal, Object upperVal, boolean includeLower, boolean includeUpper) {
        this.field = Objects.requireNonNull(field);
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DocValuesRangeQuery that = (DocValuesRangeQuery)((Object)obj);
        return this.field.equals(that.field) && Objects.equals(this.lowerVal, that.lowerVal) && Objects.equals(this.upperVal, that.upperVal) && this.includeLower == that.includeLower && this.includeUpper == that.includeUpper && super.equals(obj);
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.field, this.lowerVal, this.upperVal, this.includeLower, this.includeUpper);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field).append(':');
        }
        sb.append(this.includeLower ? (char)'[' : '{');
        sb.append(this.lowerVal == null ? "*" : this.lowerVal.toString());
        sb.append(" TO ");
        sb.append(this.upperVal == null ? "*" : this.upperVal.toString());
        sb.append(this.includeUpper ? (char)']' : '}');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.lowerVal == null && this.upperVal == null) {
            return new FieldValueQuery(this.field);
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (this.lowerVal == null && this.upperVal == null) {
            throw new IllegalStateException("Both min and max values cannot be null, call rewrite first");
        }
        return new RandomAccessWeight(this){

            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                if (DocValuesRangeQuery.this.lowerVal instanceof Long || DocValuesRangeQuery.this.upperVal instanceof Long) {
                    long max;
                    final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)DocValuesRangeQuery.this.field);
                    final long min = DocValuesRangeQuery.this.lowerVal == null ? Long.MIN_VALUE : (DocValuesRangeQuery.this.includeLower ? (Long)DocValuesRangeQuery.this.lowerVal : 1L + (Long)DocValuesRangeQuery.this.lowerVal);
                    if (min > (max = DocValuesRangeQuery.this.upperVal == null ? Long.MAX_VALUE : (DocValuesRangeQuery.this.includeUpper ? (Long)DocValuesRangeQuery.this.upperVal : -1L + (Long)DocValuesRangeQuery.this.upperVal))) {
                        return null;
                    }
                    return new Bits(){

                        public boolean get(int doc) {
                            values.setDocument(doc);
                            int count = values.count();
                            for (int i = 0; i < count; ++i) {
                                long value = values.valueAt(i);
                                if (value < min || value > max) continue;
                                return true;
                            }
                            return false;
                        }

                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
                if (DocValuesRangeQuery.this.lowerVal instanceof BytesRef || DocValuesRangeQuery.this.upperVal instanceof BytesRef) {
                    long ord;
                    long maxOrd;
                    long ord2;
                    final SortedSetDocValues values = DocValues.getSortedSet((LeafReader)context.reader(), (String)DocValuesRangeQuery.this.field);
                    final long minOrd = DocValuesRangeQuery.this.lowerVal == null ? 0L : ((ord2 = values.lookupTerm((BytesRef)DocValuesRangeQuery.this.lowerVal)) < 0L ? -1L - ord2 : (DocValuesRangeQuery.this.includeLower ? ord2 : ord2 + 1L));
                    if (minOrd > (maxOrd = DocValuesRangeQuery.this.upperVal == null ? values.getValueCount() - 1L : ((ord = values.lookupTerm((BytesRef)DocValuesRangeQuery.this.upperVal)) < 0L ? -2L - ord : (DocValuesRangeQuery.this.includeUpper ? ord : ord - 1L)))) {
                        return null;
                    }
                    return new Bits(){

                        public boolean get(int doc) {
                            values.setDocument(doc);
                            long ord = values.nextOrd();
                            while (ord != -1L) {
                                if (ord >= minOrd && ord <= maxOrd) {
                                    return true;
                                }
                                ord = values.nextOrd();
                            }
                            return false;
                        }

                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
                throw new AssertionError();
            }
        };
    }
}

