/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.internals.UpgradeFromValues;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.apache.kafka.streams.processor.internals.assignment.HighAvailabilityTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.ReferenceContainer;
import org.apache.kafka.streams.processor.internals.assignment.TaskAssignor;
import org.slf4j.Logger;

public final class AssignorConfiguration {
    private final String taskAssignorClass;
    private final String logPrefix;
    private final Logger log;
    private final ReferenceContainer referenceContainer;
    private final StreamsConfig streamsConfig;
    private final Map<String, ?> internalConfigs;

    public AssignorConfiguration(Map<String, ?> configs) {
        this.streamsConfig = new ClientUtils.QuietStreamsConfig(configs);
        this.internalConfigs = configs;
        this.logPrefix = String.format("stream-thread [%s] ", this.streamsConfig.getString("client.id"));
        LogContext logContext = new LogContext(this.logPrefix);
        this.log = logContext.logger(this.getClass());
        Object o = configs.get("__reference.container.instance__");
        if (o == null) {
            KafkaException fatalException = new KafkaException("ReferenceContainer is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(o instanceof ReferenceContainer)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), ReferenceContainer.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        this.referenceContainer = (ReferenceContainer)o;
        o = (String)configs.get("internal.task.assignor.class");
        this.taskAssignorClass = o == null ? HighAvailabilityTaskAssignor.class.getName() : o;
    }

    public ReferenceContainer referenceContainer() {
        return this.referenceContainer;
    }

    public ConsumerPartitionAssignor.RebalanceProtocol rebalanceProtocol() {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (UpgradeFromValues.getValueFromString(upgradeFrom)) {
                case UPGRADE_FROM_0100: 
                case UPGRADE_FROM_0101: 
                case UPGRADE_FROM_0102: 
                case UPGRADE_FROM_0110: 
                case UPGRADE_FROM_10: 
                case UPGRADE_FROM_11: 
                case UPGRADE_FROM_20: 
                case UPGRADE_FROM_21: 
                case UPGRADE_FROM_22: 
                case UPGRADE_FROM_23: {
                    this.log.info("Eager rebalancing protocol is enabled now for upgrade from {}.x", (Object)upgradeFrom);
                    this.log.warn("The eager rebalancing protocol is deprecated and will stop being supported in a future release. Please be prepared to remove the 'upgrade.from' config soon.");
                    return ConsumerPartitionAssignor.RebalanceProtocol.EAGER;
                }
                case UPGRADE_FROM_24: 
                case UPGRADE_FROM_25: 
                case UPGRADE_FROM_26: 
                case UPGRADE_FROM_27: 
                case UPGRADE_FROM_28: 
                case UPGRADE_FROM_30: 
                case UPGRADE_FROM_31: 
                case UPGRADE_FROM_32: 
                case UPGRADE_FROM_33: 
                case UPGRADE_FROM_34: 
                case UPGRADE_FROM_35: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
                }
            }
        }
        this.log.info("Cooperative rebalancing protocol is enabled now");
        return ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE;
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    public int configuredMetadataVersion(int priorVersion) {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (UpgradeFromValues.getValueFromString(upgradeFrom)) {
                case UPGRADE_FROM_0100: {
                    this.log.info("Downgrading metadata version from {} to 1 for upgrade from 0.10.0.x.", (Object)11);
                    return 1;
                }
                case UPGRADE_FROM_0101: 
                case UPGRADE_FROM_0102: 
                case UPGRADE_FROM_0110: 
                case UPGRADE_FROM_10: 
                case UPGRADE_FROM_11: {
                    this.log.info("Downgrading metadata version from {} to 2 for upgrade from {}.x.", (Object)11, (Object)upgradeFrom);
                    return 2;
                }
                case UPGRADE_FROM_20: 
                case UPGRADE_FROM_21: 
                case UPGRADE_FROM_22: 
                case UPGRADE_FROM_23: {
                    break;
                }
                case UPGRADE_FROM_24: 
                case UPGRADE_FROM_25: 
                case UPGRADE_FROM_26: 
                case UPGRADE_FROM_27: 
                case UPGRADE_FROM_28: 
                case UPGRADE_FROM_30: 
                case UPGRADE_FROM_31: 
                case UPGRADE_FROM_32: 
                case UPGRADE_FROM_33: 
                case UPGRADE_FROM_34: 
                case UPGRADE_FROM_35: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
                }
            }
        }
        return priorVersion;
    }

    public String userEndPoint() {
        String configuredUserEndpoint = this.streamsConfig.getString("application.server");
        if (configuredUserEndpoint != null && !configuredUserEndpoint.isEmpty()) {
            try {
                String host = Utils.getHost((String)configuredUserEndpoint);
                Integer port = Utils.getPort((String)configuredUserEndpoint);
                if (host == null || port == null) {
                    throw new ConfigException(String.format("%s Config %s isn't in the correct format. Expected a host:port pair but received %s", this.logPrefix, "application.server", configuredUserEndpoint));
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException(String.format("%s Invalid port supplied in %s for config %s: %s", this.logPrefix, configuredUserEndpoint, "application.server", nfe));
            }
            return configuredUserEndpoint;
        }
        return null;
    }

    public InternalTopicManager internalTopicManager() {
        return new InternalTopicManager(this.referenceContainer.time, this.referenceContainer.adminClient, this.streamsConfig);
    }

    public CopartitionedTopicsEnforcer copartitionedTopicsEnforcer() {
        return new CopartitionedTopicsEnforcer(this.logPrefix);
    }

    public AssignmentConfigs assignmentConfigs() {
        return new AssignmentConfigs(this.streamsConfig);
    }

    public TaskAssignor taskAssignor() {
        try {
            return (TaskAssignor)Utils.newInstance((String)this.taskAssignorClass, TaskAssignor.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Expected an instantiable class name for internal.task.assignor.class", e);
        }
    }

    public AssignmentListener assignmentListener() {
        Object o = this.internalConfigs.get("__assignment.listener__");
        if (o == null) {
            return stable -> {};
        }
        if (!(o instanceof AssignmentListener)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), AssignmentListener.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (AssignmentListener)o;
    }

    public static class AssignmentConfigs {
        public final long acceptableRecoveryLag;
        public final int maxWarmupReplicas;
        public final int numStandbyReplicas;
        public final long probingRebalanceIntervalMs;
        public final List<String> rackAwareAssignmentTags;
        public final Integer rackAwareAssignmentTrafficCost;
        public final Integer rackAwareAssignmentNonOverlapCost;
        public final String rackAwareAssignmentStrategy;

        private AssignmentConfigs(StreamsConfig configs) {
            this.acceptableRecoveryLag = configs.getLong("acceptable.recovery.lag");
            this.maxWarmupReplicas = configs.getInt("max.warmup.replicas");
            this.numStandbyReplicas = configs.getInt("num.standby.replicas");
            this.probingRebalanceIntervalMs = configs.getLong("probing.rebalance.interval.ms");
            this.rackAwareAssignmentTags = configs.getList("rack.aware.assignment.tags");
            this.rackAwareAssignmentTrafficCost = configs.getInt("rack.aware.assignment.traffic_cost");
            this.rackAwareAssignmentNonOverlapCost = configs.getInt("rack.aware.assignment.non_overlap_cost");
            this.rackAwareAssignmentStrategy = configs.getString("rack.aware.assignment.strategy");
        }

        AssignmentConfigs(Long acceptableRecoveryLag, Integer maxWarmupReplicas, Integer numStandbyReplicas, Long probingRebalanceIntervalMs, List<String> rackAwareAssignmentTags) {
            this(acceptableRecoveryLag, maxWarmupReplicas, numStandbyReplicas, probingRebalanceIntervalMs, rackAwareAssignmentTags, null, null, "none");
        }

        AssignmentConfigs(Long acceptableRecoveryLag, Integer maxWarmupReplicas, Integer numStandbyReplicas, Long probingRebalanceIntervalMs, List<String> rackAwareAssignmentTags, Integer rackAwareAssignmentTrafficCost, Integer rackAwareAssignmentNonOverlapCost, String rackAwareAssignmentStrategy) {
            this.acceptableRecoveryLag = AssignmentConfigs.validated("acceptable.recovery.lag", acceptableRecoveryLag);
            this.maxWarmupReplicas = AssignmentConfigs.validated("max.warmup.replicas", maxWarmupReplicas);
            this.numStandbyReplicas = AssignmentConfigs.validated("num.standby.replicas", numStandbyReplicas);
            this.probingRebalanceIntervalMs = AssignmentConfigs.validated("probing.rebalance.interval.ms", probingRebalanceIntervalMs);
            this.rackAwareAssignmentTags = AssignmentConfigs.validated("rack.aware.assignment.tags", rackAwareAssignmentTags);
            this.rackAwareAssignmentTrafficCost = AssignmentConfigs.validated("rack.aware.assignment.traffic_cost", rackAwareAssignmentTrafficCost);
            this.rackAwareAssignmentNonOverlapCost = AssignmentConfigs.validated("rack.aware.assignment.non_overlap_cost", rackAwareAssignmentNonOverlapCost);
            this.rackAwareAssignmentStrategy = AssignmentConfigs.validated("rack.aware.assignment.strategy", rackAwareAssignmentStrategy);
        }

        private static <T> T validated(String configKey, T value) {
            ConfigDef.Validator validator = ((ConfigDef.ConfigKey)StreamsConfig.configDef().configKeys().get((Object)configKey)).validator;
            if (validator != null) {
                validator.ensureValid(configKey, value);
            }
            return value;
        }

        public String toString() {
            return "AssignmentConfigs{\n  acceptableRecoveryLag=" + this.acceptableRecoveryLag + "\n  maxWarmupReplicas=" + this.maxWarmupReplicas + "\n  numStandbyReplicas=" + this.numStandbyReplicas + "\n  probingRebalanceIntervalMs=" + this.probingRebalanceIntervalMs + "\n  rackAwareAssignmentTags=" + this.rackAwareAssignmentTags + "\n}";
        }
    }

    public static interface AssignmentListener {
        public void onAssignmentComplete(boolean var1);
    }
}

