/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class StatefulProcessorNode<K, V>
extends ProcessorGraphNode<K, V> {
    private final String[] storeNames;
    private final StoreBuilder<?> storeBuilder;

    public StatefulProcessorNode(ProcessorParameters<K, V, ?, ?> processorParameters, Set<StoreBuilder<?>> preRegisteredStores, Set<KTableValueGetterSupplier<?, ?>> valueGetterSuppliers) {
        super(processorParameters.processorName(), processorParameters);
        Stream<String> registeredStoreNames = preRegisteredStores.stream().map(StoreBuilder::name);
        Stream valueGetterStoreNames = valueGetterSuppliers.stream().flatMap(s -> Arrays.stream(s.storeNames()));
        this.storeNames = (String[])Stream.concat(registeredStoreNames, valueGetterStoreNames).toArray(String[]::new);
        this.storeBuilder = null;
    }

    public StatefulProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, String[] storeNames) {
        super(nodeName, processorParameters);
        this.storeNames = storeNames;
        this.storeBuilder = null;
    }

    public StatefulProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreBuilder<?> materializedKTableStoreBuilder) {
        super(nodeName, processorParameters);
        this.storeNames = null;
        this.storeBuilder = materializedKTableStoreBuilder;
    }

    @Override
    public String toString() {
        return "StatefulProcessorNode{storeNames=" + Arrays.toString(this.storeNames) + ", storeBuilder=" + this.storeBuilder + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        this.processorParameters().addProcessorTo(topologyBuilder, this.parentNodeNames());
        if (this.storeNames != null && this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(this.processorParameters().processorName(), this.storeNames);
        }
        if (this.storeBuilder != null) {
            topologyBuilder.addStateStore(this.storeBuilder, this.processorParameters().processorName());
        }
    }
}

