/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.BrokersToIsrs;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;

public class BrokersToElrs {
    private final SnapshotRegistry snapshotRegistry;
    private final TimelineHashMap<Integer, TimelineHashMap<Uuid, int[]>> elrMembers;

    BrokersToElrs(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.elrMembers = new TimelineHashMap(snapshotRegistry, 0);
    }

    void update(Uuid topicId, int partitionId, int[] prevElr, int[] nextElr) {
        int[] next;
        int[] prev;
        if (prevElr == null) {
            prev = Replicas.NONE;
        } else {
            prev = Replicas.clone(prevElr);
            Arrays.sort(prev);
        }
        if (nextElr == null) {
            next = Replicas.NONE;
        } else {
            next = Replicas.clone(nextElr);
            Arrays.sort(next);
        }
        int i = 0;
        int j = 0;
        while (true) {
            int prevReplica;
            if (i == prev.length) {
                if (j == next.length) break;
                int newReplica = next[j];
                this.add(newReplica, topicId, partitionId);
                ++j;
                continue;
            }
            if (j == next.length) {
                prevReplica = prev[i];
                this.remove(prevReplica, topicId, partitionId);
                ++i;
                continue;
            }
            prevReplica = prev[i];
            int newReplica = next[j];
            if (prevReplica < newReplica) {
                this.remove(prevReplica, topicId, partitionId);
                ++i;
                continue;
            }
            if (prevReplica > newReplica) {
                this.add(newReplica, topicId, partitionId);
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
    }

    void removeTopicEntryForBroker(Uuid topicId, int brokerId) {
        Map topicMap = (Map)this.elrMembers.get((Object)brokerId);
        if (topicMap != null) {
            topicMap.remove(topicId);
        }
    }

    private void add(int brokerId, Uuid topicId, int newPartition) {
        int[] newPartitions;
        int[] partitions;
        TimelineHashMap topicMap = (TimelineHashMap)this.elrMembers.get((Object)brokerId);
        if (topicMap == null) {
            topicMap = new TimelineHashMap(this.snapshotRegistry, 0);
            this.elrMembers.put((Object)brokerId, (Object)topicMap);
        }
        if ((partitions = (int[])topicMap.get((Object)topicId)) == null) {
            newPartitions = new int[1];
        } else {
            newPartitions = new int[partitions.length + 1];
            System.arraycopy(partitions, 0, newPartitions, 0, partitions.length);
        }
        newPartitions[newPartitions.length - 1] = newPartition;
        topicMap.put((Object)topicId, (Object)newPartitions);
    }

    private void remove(int brokerId, Uuid topicId, int removedPartition) {
        TimelineHashMap topicMap = (TimelineHashMap)this.elrMembers.get((Object)brokerId);
        if (topicMap == null) {
            throw new RuntimeException("Broker " + brokerId + " has no elrMembers entry, so we can't remove " + topicId + ":" + removedPartition);
        }
        int[] partitions = (int[])topicMap.get((Object)topicId);
        if (partitions == null) {
            throw new RuntimeException("Broker " + brokerId + " has no entry in elrMembers for topic " + topicId);
        }
        if (partitions.length == 1) {
            if (partitions[0] != removedPartition) {
                throw new RuntimeException("Broker " + brokerId + " has no entry in elrMembers for " + topicId + ":" + removedPartition);
            }
            topicMap.remove((Object)topicId);
            if (topicMap.isEmpty()) {
                this.elrMembers.remove((Object)brokerId);
            }
        } else {
            int[] newPartitions = new int[partitions.length - 1];
            int j = 0;
            for (int i = 0; i < partitions.length; ++i) {
                int partition = partitions[i];
                if (partition == removedPartition) continue;
                newPartitions[j++] = partition;
            }
            topicMap.put((Object)topicId, (Object)newPartitions);
        }
    }

    BrokersToIsrs.PartitionsOnReplicaIterator partitionsWithBrokerInElr(int brokerId) {
        Map<Uuid, int[]> topicMap = (Map<Uuid, int[]>)this.elrMembers.get((Object)brokerId);
        if (topicMap == null) {
            topicMap = Collections.emptyMap();
        }
        return new BrokersToIsrs.PartitionsOnReplicaIterator(topicMap, false);
    }
}

