/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ApiErrorTest {
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void fromThrowableShouldReturnCorrectError(Throwable t, Errors expectedError, String expectedMsg) {
        ApiError apiError = ApiError.fromThrowable((Throwable)t);
        Assertions.assertEquals((Object)expectedError, (Object)apiError.error());
        Assertions.assertEquals((Object)expectedMsg, (Object)apiError.message());
    }

    private static Collection<Arguments> parameters() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{new UnknownServerException("Don't leak sensitive information "), Errors.UNKNOWN_SERVER_ERROR, null}));
        arguments.add(Arguments.of((Object[])new Object[]{new NotEnoughReplicasException(), Errors.NOT_ENOUGH_REPLICAS, null}));
        arguments.add(Arguments.of((Object[])new Object[]{new UnknownTopicOrPartitionException(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), Errors.UNKNOWN_TOPIC_OR_PARTITION, null}));
        String notCoordinatorErrorMsg = "Not coordinator";
        arguments.add(Arguments.of((Object[])new Object[]{new NotCoordinatorException(notCoordinatorErrorMsg), Errors.NOT_COORDINATOR, notCoordinatorErrorMsg}));
        String notControllerErrorMsg = "Not controller";
        arguments.add(Arguments.of((Object[])new Object[]{new CompletionException((Throwable)new NotControllerException(notControllerErrorMsg)), Errors.NOT_CONTROLLER, notControllerErrorMsg}));
        String requestTimeoutErrorMsg = "request time out";
        arguments.add(Arguments.of((Object[])new Object[]{new ExecutionException(new TimeoutException(requestTimeoutErrorMsg)), Errors.REQUEST_TIMED_OUT, requestTimeoutErrorMsg}));
        arguments.add(Arguments.of((Object[])new Object[]{new IOException(), Errors.UNKNOWN_SERVER_ERROR, null}));
        return arguments;
    }
}

