/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public final class ResultStatsUtil {
    private ResultStatsUtil() {
    }

    public static <T> T updateStats(T r, ServerStatisticTracker serverStats, ServerName server, byte[] regionName) {
        if (!(r instanceof Result)) {
            return r;
        }
        Result result = (Result)r;
        ClientProtos.RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return r;
        }
        serverStats.updateRegionStats(server, regionName, stats);
        return r;
    }

    public static <T> T updateStats(T r, ServerStatisticTracker stats, HRegionLocation regionLocation) {
        if (r instanceof MultiResponse) {
            MultiResponse mr = (MultiResponse)r;
            block0: for (Map.Entry<byte[], List<Pair<Integer, Object>>> e : mr.getResults().entrySet()) {
                byte[] regionName = e.getKey();
                for (Pair<Integer, Object> regionResult : e.getValue()) {
                    Result result;
                    ClientProtos.RegionLoadStats loadStats;
                    Object o = regionResult.getSecond();
                    if (!(o instanceof Result) || (loadStats = (result = (Result)o).getStats()) == null) continue;
                    stats.updateRegionStats(regionLocation.getServerName(), regionName, loadStats);
                    continue block0;
                }
            }
        }
        return r;
    }
}

