/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class MiniYARNCluster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager resourceManager;
    private ResourceManagerWrapper resourceManagerWrapper;
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;

    public MiniYARNCluster(String testName, int noOfNodeManagers, int numLocalDirs, int numLogDirs) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        String testSubDir = testName.replace("$", "");
        File targetWorkDir = new File("target", testSubDir);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn((Object)"COULD NOT CLEANUP", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir: " + e, (Throwable)e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.resourceManagerWrapper = new ResourceManagerWrapper();
        this.addService((Service)this.resourceManagerWrapper);
        this.nodeManagers = new CustomNodeManager[noOfNodeManagers];
        for (int index = 0; index < noOfNodeManagers; ++index) {
            this.addService((Service)new NodeManagerWrapper(index));
            this.nodeManagers[index] = new CustomNodeManager();
        }
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    private class CustomNodeManager
    extends NodeManager {
        private CustomNodeManager() {
        }

        protected void doSecureLogin() throws IOException {
        }

        protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
            return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics){

                protected ResourceTracker getRMClient() {
                    final ResourceTrackerService rt = MiniYARNCluster.this.resourceManager.getResourceTrackerService();
                    final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
                    return new ResourceTracker(){

                        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
                            NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
                            try {
                                response = rt.nodeHeartbeat(request);
                            }
                            catch (YarnException e) {
                                LOG.info((Object)("Exception in heartbeat from node " + request.getNodeStatus().getNodeId()), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }

                        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
                            RegisterNodeManagerResponse response = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
                            try {
                                response = rt.registerNodeManager(request);
                            }
                            catch (YarnException e) {
                                LOG.info((Object)("Exception in node registration from " + request.getNodeId().toString()), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }
                    };
                }

                protected void stopRMProxy() {
                }
            };
        }
    }

    private class NodeManagerWrapper
    extends AbstractService {
        int index;

        public NodeManagerWrapper(int i) {
            super(NodeManagerWrapper.class.getName() + "_" + i);
            this.index = 0;
            this.index = i;
        }

        public synchronized void serviceInit(Configuration conf) throws Exception {
            YarnConfiguration config = new YarnConfiguration(conf);
            super.serviceInit((Configuration)config);
        }

        private String prepareDirs(String dirType, int numDirs) {
            File[] dirs = new File[numDirs];
            String dirsString = "";
            for (int i = 0; i < numDirs; ++i) {
                dirs[i] = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-" + dirType + "Dir-nm-" + this.index + "_" + i);
                dirs[i].mkdirs();
                LOG.info((Object)("Created " + dirType + "Dir in " + dirs[i].getAbsolutePath()));
                String delimiter = i > 0 ? "," : "";
                dirsString = dirsString.concat(delimiter + dirs[i].getAbsolutePath());
            }
            return dirsString;
        }

        public synchronized void serviceStart() throws Exception {
            try {
                String localDirsString = this.prepareDirs("local", MiniYARNCluster.this.numLocalDirs);
                this.getConfig().set("yarn.nodemanager.local-dirs", localDirsString);
                String logDirsString = this.prepareDirs("log", MiniYARNCluster.this.numLogDirs);
                this.getConfig().set("yarn.nodemanager.log-dirs", logDirsString);
                File remoteLogDir = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-remoteLogDir-nm-" + this.index);
                remoteLogDir.mkdir();
                this.getConfig().set("yarn.nodemanager.remote-app-log-dir", remoteLogDir.getAbsolutePath());
                this.getConfig().setInt("yarn.nodemanager.resource.memory-mb", 4096);
                this.getConfig().set("yarn.nodemanager.address", MiniYARNCluster.getHostname() + ":0");
                this.getConfig().set("yarn.nodemanager.localizer.address", MiniYARNCluster.getHostname() + ":0");
                WebAppUtils.setNMWebAppHostNameAndPort((Configuration)this.getConfig(), (String)MiniYARNCluster.getHostname(), (int)0);
                if (!this.getConfig().getBoolean("yarn.minicluster.control-resource-monitoring", false)) {
                    this.getConfig().setBoolean("yarn.nodemanager.pmem-check-enabled", false);
                    this.getConfig().setBoolean("yarn.nodemanager.vmem-check-enabled", false);
                }
                LOG.info((Object)("Starting NM: " + this.index));
                MiniYARNCluster.this.nodeManagers[this.index].init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.nodeManagers[NodeManagerWrapper.this.index].start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)("Waiting for NM " + this.index + " to start..."));
                    Thread.sleep(1000L);
                }
                if (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("NodeManager " + this.index + " failed to start");
                }
                super.serviceStart();
            }
            catch (Throwable t) {
                throw new YarnRuntimeException(t);
            }
        }

        public synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.nodeManagers[this.index] != null) {
                MiniYARNCluster.this.nodeManagers[this.index].stop();
            }
            super.serviceStop();
        }
    }

    private class ResourceManagerWrapper
    extends AbstractService {
        public ResourceManagerWrapper() {
            super(ResourceManagerWrapper.class.getName());
        }

        public synchronized void serviceStart() throws Exception {
            try {
                this.getConfig().setBoolean("yarn.is.minicluster", true);
                if (!this.getConfig().getBoolean("yarn.minicluster.fixed.ports", YarnConfiguration.DEFAULT_YARN_MINICLUSTER_FIXED_PORTS)) {
                    String hostname = MiniYARNCluster.getHostname();
                    this.getConfig().set("yarn.resourcemanager.address", hostname + ":0");
                    this.getConfig().set("yarn.resourcemanager.admin.address", hostname + ":0");
                    this.getConfig().set("yarn.resourcemanager.scheduler.address", hostname + ":0");
                    this.getConfig().set("yarn.resourcemanager.resource-tracker.address", hostname + ":0");
                    WebAppUtils.setRMWebAppHostnameAndPort((Configuration)this.getConfig(), (String)hostname, (int)0);
                }
                MiniYARNCluster.this.resourceManager = new ResourceManager(){

                    protected void doSecureLogin() throws IOException {
                    }
                };
                MiniYARNCluster.this.resourceManager.init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.resourceManager.start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)"Waiting for RM to start...");
                    Thread.sleep(1500L);
                }
                if (MiniYARNCluster.this.resourceManager.getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("ResourceManager failed to start. Final state is " + MiniYARNCluster.this.resourceManager.getServiceState());
                }
                super.serviceStart();
            }
            catch (Throwable t) {
                throw new YarnRuntimeException(t);
            }
            LOG.info((Object)("MiniYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
            LOG.info((Object)("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConfig())));
        }

        public synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.resourceManager != null) {
                MiniYARNCluster.this.resourceManager.stop();
            }
            super.serviceStop();
            if (Shell.WINDOWS) {
                String testWorkDirPath = MiniYARNCluster.this.testWorkDir.getAbsolutePath();
                try {
                    FileContext.getLocalFSFileContext().delete(new Path(testWorkDirPath), true);
                }
                catch (IOException e) {
                    LOG.warn((Object)("could not cleanup symlink: " + MiniYARNCluster.this.testWorkDir.getAbsolutePath()));
                }
            }
        }
    }
}

