/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientToAMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private ApplicationAttemptId applicationAttemptId;
    private Text clientName = new Text();

    public ClientToAMTokenIdentifier() {
    }

    public ClientToAMTokenIdentifier(ApplicationAttemptId id, String client) {
        this();
        this.applicationAttemptId = id;
        this.clientName = new Text(client);
    }

    public ApplicationAttemptId getApplicationAttemptID() {
        return this.applicationAttemptId;
    }

    public String getClientName() {
        return this.clientName.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationAttemptId.getApplicationId().getClusterTimestamp());
        out.writeInt(this.applicationAttemptId.getApplicationId().getId());
        out.writeInt(this.applicationAttemptId.getAttemptId());
        this.clientName.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)in.readLong(), (int)in.readInt()), (int)in.readInt());
        this.clientName.readFields(in);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.clientName == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.clientName.toString());
    }
}

