/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineRecords {
    private static final Log LOG = LogFactory.getLog(TestTimelineRecords.class);

    @Test
    public void testEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        for (int j = 0; j < 2; ++j) {
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("entity id " + j);
            entity.setEntityType("entity type " + j);
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            for (int i = 0; i < 2; ++i) {
                TimelineEvent event = new TimelineEvent();
                event.setTimestamp(System.currentTimeMillis());
                event.setEventType("event type " + i);
                event.addEventInfo("key1", (Object)"val1");
                event.addEventInfo("key2", (Object)"val2");
                entity.addEvent(event);
            }
            entity.addRelatedEntity("test ref type 1", "test ref id 1");
            entity.addRelatedEntity("test ref type 2", "test ref id 2");
            entity.addPrimaryFilter("pkey1", (Object)"pval1");
            entity.addPrimaryFilter("pkey2", (Object)"pval2");
            entity.addOtherInfo("okey1", (Object)"oval1");
            entity.addOtherInfo("okey2", (Object)"oval2");
            entities.addEntity(entity);
        }
        LOG.info((Object)"Entities in JSON:");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entities, (boolean)true));
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        Assert.assertEquals((Object)"entity id 0", (Object)entity1.getEntityId());
        Assert.assertEquals((Object)"entity type 0", (Object)entity1.getEntityType());
        Assert.assertEquals((long)2L, (long)entity1.getRelatedEntities().size());
        Assert.assertEquals((long)2L, (long)entity1.getEvents().size());
        Assert.assertEquals((long)2L, (long)entity1.getPrimaryFilters().size());
        Assert.assertEquals((long)2L, (long)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        Assert.assertEquals((Object)"entity id 1", (Object)entity2.getEntityId());
        Assert.assertEquals((Object)"entity type 1", (Object)entity2.getEntityType());
        Assert.assertEquals((long)2L, (long)entity2.getRelatedEntities().size());
        Assert.assertEquals((long)2L, (long)entity2.getEvents().size());
        Assert.assertEquals((long)2L, (long)entity2.getPrimaryFilters().size());
        Assert.assertEquals((long)2L, (long)entity2.getOtherInfo().size());
    }

    @Test
    public void testEvents() throws Exception {
        TimelineEvents events = new TimelineEvents();
        for (int j = 0; j < 2; ++j) {
            TimelineEvents.EventsOfOneEntity partEvents = new TimelineEvents.EventsOfOneEntity();
            partEvents.setEntityId("entity id " + j);
            partEvents.setEntityType("entity type " + j);
            for (int i = 0; i < 2; ++i) {
                TimelineEvent event = new TimelineEvent();
                event.setTimestamp(System.currentTimeMillis());
                event.setEventType("event type " + i);
                event.addEventInfo("key1", (Object)"val1");
                event.addEventInfo("key2", (Object)"val2");
                partEvents.addEvent(event);
            }
            events.addEvent(partEvents);
        }
        LOG.info((Object)"Events in JSON:");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)events, (boolean)true));
        Assert.assertEquals((long)2L, (long)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents1 = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        Assert.assertEquals((Object)"entity id 0", (Object)partEvents1.getEntityId());
        Assert.assertEquals((Object)"entity type 0", (Object)partEvents1.getEntityType());
        Assert.assertEquals((long)2L, (long)partEvents1.getEvents().size());
        TimelineEvent event11 = (TimelineEvent)partEvents1.getEvents().get(0);
        Assert.assertEquals((Object)"event type 0", (Object)event11.getEventType());
        Assert.assertEquals((long)2L, (long)event11.getEventInfo().size());
        TimelineEvent event12 = (TimelineEvent)partEvents1.getEvents().get(1);
        Assert.assertEquals((Object)"event type 1", (Object)event12.getEventType());
        Assert.assertEquals((long)2L, (long)event12.getEventInfo().size());
        TimelineEvents.EventsOfOneEntity partEvents2 = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(1);
        Assert.assertEquals((Object)"entity id 1", (Object)partEvents2.getEntityId());
        Assert.assertEquals((Object)"entity type 1", (Object)partEvents2.getEntityType());
        Assert.assertEquals((long)2L, (long)partEvents2.getEvents().size());
        TimelineEvent event21 = (TimelineEvent)partEvents2.getEvents().get(0);
        Assert.assertEquals((Object)"event type 0", (Object)event21.getEventType());
        Assert.assertEquals((long)2L, (long)event21.getEventInfo().size());
        TimelineEvent event22 = (TimelineEvent)partEvents2.getEvents().get(1);
        Assert.assertEquals((Object)"event type 1", (Object)event22.getEventType());
        Assert.assertEquals((long)2L, (long)event22.getEventInfo().size());
    }

    @Test
    public void testTimelinePutErrors() throws Exception {
        TimelinePutResponse TimelinePutErrors = new TimelinePutResponse();
        TimelinePutResponse.TimelinePutError error1 = new TimelinePutResponse.TimelinePutError();
        error1.setEntityId("entity id 1");
        error1.setEntityId("entity type 1");
        error1.setErrorCode(1);
        TimelinePutErrors.addError(error1);
        ArrayList<TimelinePutResponse.TimelinePutError> response = new ArrayList<TimelinePutResponse.TimelinePutError>();
        response.add(error1);
        TimelinePutResponse.TimelinePutError error2 = new TimelinePutResponse.TimelinePutError();
        error2.setEntityId("entity id 2");
        error2.setEntityId("entity type 2");
        error2.setErrorCode(2);
        response.add(error2);
        TimelinePutErrors.addErrors(response);
        LOG.info((Object)"Errors in JSON:");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)TimelinePutErrors, (boolean)true));
        Assert.assertEquals((long)3L, (long)TimelinePutErrors.getErrors().size());
        TimelinePutResponse.TimelinePutError e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(0);
        Assert.assertEquals((Object)error1.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error1.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error1.getErrorCode(), (long)e.getErrorCode());
        e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(1);
        Assert.assertEquals((Object)error1.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error1.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error1.getErrorCode(), (long)e.getErrorCode());
        e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(2);
        Assert.assertEquals((Object)error2.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error2.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error2.getErrorCode(), (long)e.getErrorCode());
    }
}

