/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import junit.framework.TestCase;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner;

public class TestKeyFieldBasedPartitioner
extends TestCase {
    public void testEmptyKey() throws Exception {
        int numReducers = 10;
        KeyFieldBasedPartitioner kfbp = new KeyFieldBasedPartitioner();
        JobConf conf = new JobConf();
        conf.setInt("num.key.fields.for.partition", 10);
        kfbp.configure(conf);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Empty key should map to 0th partition", (int)0, (int)kfbp.getPartition((Object)new Text(), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        kfbp.configure(conf);
        String input = "abc\tdef\txyz";
        int hashCode = input.hashCode();
        int expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k2,2");
        kfbp.configure(conf);
        String expectedOutput = "def";
        byte[] eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k2,5");
        kfbp.configure(conf);
        expectedOutput = "def\txyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k2");
        kfbp.configure(conf);
        expectedOutput = "def\txyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k10");
        kfbp.configure(conf);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)0, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k2,2 -k4,4");
        kfbp.configure(conf);
        input = "abc\tdef\tpqr\txyz";
        expectedOutput = "def";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedOutput = "xyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, hashCode);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
        kfbp = new KeyFieldBasedPartitioner();
        conf = new JobConf();
        conf.set("mapred.text.key.partitioner.options", "-k2,2 -k30,21 -k4,4 -k5");
        kfbp.configure(conf);
        expectedOutput = "def";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedOutput = "xyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, hashCode);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        TestKeyFieldBasedPartitioner.assertEquals((String)"Partitioner doesnt work as expected", (int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers));
    }
}

