/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputLogFilter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestUserDefinedCounters
extends ClusterMapReduceTestCase {
    public void testMapReduceJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("counters");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(CountingMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        RunningJob runningJob = JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(this.getOutputDir(), (PathFilter)new OutputLogFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                ++counter;
                TestUserDefinedCounters.assertTrue((boolean)line.contains("hello"));
                line = reader.readLine();
            }
            reader.close();
            TestUserDefinedCounters.assertEquals((int)4, (int)counter);
        }
        TestUserDefinedCounters.assertEquals((long)4L, (long)runningJob.getCounters().getCounter((Enum)EnumCounter.MAP_RECORDS));
        TestUserDefinedCounters.assertEquals((long)4L, (long)runningJob.getCounters().getGroup("StringCounter").getCounter("MapRecords"));
    }

    static class CountingMapper<K, V>
    extends IdentityMapper<K, V> {
        CountingMapper() {
        }

        public void map(K key, V value, OutputCollector<K, V> output, Reporter reporter) throws IOException {
            output.collect(key, value);
            reporter.incrCounter((Enum)EnumCounter.MAP_RECORDS, 1L);
            reporter.incrCounter("StringCounter", "MapRecords", 1L);
        }
    }

    static enum EnumCounter {
        MAP_RECORDS;

    }
}

