/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import testshell.ExternalMapReduce;

public class TestCommandLineJobSubmission
extends TestCase {
    static final Path input = new Path("/test/input/");
    static final Path output = new Path("/test/output");
    File buildDir = new File(System.getProperty("test.build.data", "/tmp"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobShell() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fs = null;
        Path testFile = new Path(input, "testfile");
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 2, true, null);
            fs = dfs.getFileSystem();
            FSDataOutputStream stream = fs.create(testFile);
            stream.write("teststring".getBytes());
            stream.close();
            mr = new MiniMRCluster(2, fs.getUri().toString(), 1);
            File thisbuildDir = new File(this.buildDir, "jobCommand");
            TestCommandLineJobSubmission.assertTrue((String)"create build dir", (boolean)thisbuildDir.mkdirs());
            File f = new File(thisbuildDir, "files_tmp");
            FileOutputStream fstream = new FileOutputStream(f);
            fstream.write("somestrings".getBytes());
            fstream.close();
            String[] args = new String[]{"-files", f.toString(), "-libjars", "build/test/testjar/testjob.jar", input.toString(), output.toString()};
            JobConf jobConf = mr.createJobConf();
            TestCommandLineJobSubmission.assertTrue((String)"libjar not in client classpath", (this.loadLibJar(jobConf) == null ? 1 : 0) != 0);
            int ret = ToolRunner.run((Configuration)jobConf, (Tool)new ExternalMapReduce(), (String[])args);
            TestCommandLineJobSubmission.assertTrue((String)"libjar added to client classpath", (this.loadLibJar(jobConf) != null ? 1 : 0) != 0);
            TestCommandLineJobSubmission.assertTrue((String)"not failed ", (ret != -1 ? 1 : 0) != 0);
            f.delete();
            thisbuildDir.delete();
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private Class loadLibJar(JobConf jobConf) {
        try {
            return jobConf.getClassByName("testjar.ClassWordCount");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

