/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import junit.framework.TestCase;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.Host2NodesMap;

public class TestHost2NodesMap
extends TestCase {
    private static Host2NodesMap map = new Host2NodesMap();
    private static final DatanodeDescriptor[] dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h3:5030"), "/d1/r2")};
    private static final DatanodeDescriptor NULL_NODE = null;
    private static final DatanodeDescriptor NODE = new DatanodeDescriptor(new DatanodeID("h3:5040"), "/d1/r4");

    public void testContains() throws Exception {
        for (int i = 0; i < dataNodes.length; ++i) {
            TestHost2NodesMap.assertTrue((boolean)map.contains(dataNodes[i]));
        }
        TestHost2NodesMap.assertFalse((boolean)map.contains(NULL_NODE));
        TestHost2NodesMap.assertFalse((boolean)map.contains(NODE));
    }

    public void testGetDatanodeByHost() throws Exception {
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h1") == dataNodes[0] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h2") == dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = map.getDatanodeByHost("h3");
        TestHost2NodesMap.assertTrue((node == dataNodes[2] || node == dataNodes[3] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((null == map.getDatanodeByHost("h4") ? 1 : 0) != 0);
    }

    public void testGetDatanodeByName() throws Exception {
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h1:5020") == dataNodes[0] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h1:5030") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h2:5020") == dataNodes[1] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h2:5030") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h3:5020") == dataNodes[2] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h3:5030") == dataNodes[3] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h3:5040") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName("h4") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByName(null) == null ? 1 : 0) != 0);
    }

    public void testRemove() throws Exception {
        TestHost2NodesMap.assertFalse((boolean)map.remove(NODE));
        TestHost2NodesMap.assertTrue((boolean)map.remove(dataNodes[0]));
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h2") == dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = map.getDatanodeByHost("h3");
        TestHost2NodesMap.assertTrue((node == dataNodes[2] || node == dataNodes[3] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((null == map.getDatanodeByHost("h4") ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((boolean)map.remove(dataNodes[2]));
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h2") == dataNodes[1] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h3") == dataNodes[3] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((boolean)map.remove(dataNodes[3]));
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h2") == dataNodes[1] ? 1 : 0) != 0);
        TestHost2NodesMap.assertTrue((map.getDatanodeByHost("h3") == null ? 1 : 0) != 0);
        TestHost2NodesMap.assertFalse((boolean)map.remove(NULL_NODE));
        TestHost2NodesMap.assertTrue((boolean)map.remove(dataNodes[1]));
        TestHost2NodesMap.assertFalse((boolean)map.remove(dataNodes[1]));
    }

    static {
        for (DatanodeDescriptor node : dataNodes) {
            map.add(node);
        }
        map.add(NULL_NODE);
    }
}

