/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class TestDecommission
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int numDatanodes = 6;
    Random myrand = new Random();
    Path hostsFile;
    Path excludeFile;
    ArrayList<String> decommissionedNodes = new ArrayList(6);

    private void writeConfigFile(FileSystem fs, Path name, ArrayList<String> nodes) throws IOException {
        if (fs.exists(name)) {
            fs.delete(name, true);
        }
        FSDataOutputStream stm = fs.create(name);
        if (nodes != null) {
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
        }
        stm.close();
    }

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    private void printFileLocations(FileSystem fileSys, Path name) throws IOException {
        BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 16384L);
        for (int idx = 0; idx < locations.length; ++idx) {
            String[] loc = locations[idx].getHosts();
            System.out.print("Block[" + idx + "] : ");
            for (int j = 0; j < loc.length; ++j) {
                System.out.print(loc[j] + " ");
            }
            System.out.println("");
        }
    }

    private void checkFile(FileSystem fileSys, Path name, int repl, String downnode) throws IOException {
        TestDecommission.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        DFSClient.DFSDataInputStream dis = (DFSClient.DFSDataInputStream)((DistributedFileSystem)fileSys).open(name);
        List dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int hasdown = 0;
            DatanodeInfo[] nodes = blk.getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                if (!nodes[j].getName().equals(downnode)) continue;
                ++hasdown;
                System.out.println("Block " + blk.getBlock() + " replica " + nodes[j].getName() + " is decommissioned.");
            }
            System.out.println("Block " + blk.getBlock() + " has " + hasdown + " decommissioned replica.");
            TestDecommission.assertEquals((String)("Number of replicas for block" + blk.getBlock()), (int)Math.min(6, repl + hasdown), (int)nodes.length);
        }
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestDecommission.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestDecommission.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private void printDatanodeReport(DatanodeInfo[] info) {
        System.out.println("-------------------------------------------------");
        for (int i = 0; i < info.length; ++i) {
            System.out.println(info[i].getDatanodeReport());
            System.out.println();
        }
    }

    private String decommissionNode(NameNode namenode, Configuration conf, DFSClient client, FileSystem localFileSys) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(FSConstants.DatanodeReportType.LIVE);
        int index = 0;
        boolean found = false;
        while (!found) {
            index = this.myrand.nextInt(info.length);
            if (info[index].isDecommissioned()) continue;
            found = true;
        }
        String nodename = info[index].getName();
        System.out.println("Decommissioning node: " + nodename);
        ArrayList<String> nodes = new ArrayList<String>(this.decommissionedNodes);
        nodes.add(nodename);
        this.writeConfigFile(localFileSys, this.excludeFile, nodes);
        namenode.namesystem.refreshNodes(conf);
        return nodename;
    }

    private boolean checkNodeState(FileSystem filesys, String node, NodeState state) throws IOException {
        DistributedFileSystem dfs = (DistributedFileSystem)filesys;
        boolean done = false;
        boolean foundNode = false;
        DatanodeInfo[] datanodes = dfs.getDataNodeStats();
        for (int i = 0; i < datanodes.length; ++i) {
            DatanodeInfo dn = datanodes[i];
            if (!dn.getName().equals(node)) continue;
            done = state == NodeState.DECOMMISSIONED ? dn.isDecommissioned() : (state == NodeState.DECOMMISSION_INPROGRESS ? dn.isDecommissionInProgress() : !dn.isDecommissionInProgress() && !dn.isDecommissioned());
            System.out.println(dn.getDatanodeReport());
            foundNode = true;
        }
        if (!foundNode) {
            throw new IOException("Could not find node: " + node);
        }
        return done;
    }

    private void waitNodeState(FileSystem filesys, String node, NodeState state) throws IOException {
        boolean done = this.checkNodeState(filesys, node, state);
        while (!done) {
            System.out.println("Waiting for node " + node + " to change state to " + (Object)((Object)state));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = this.checkNodeState(filesys, node, state);
        }
    }

    public void testDecommission() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.replication.considerLoad", false);
        LocalFileSystem localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/work-dir/decommission");
        TestDecommission.assertTrue((boolean)localFileSys.mkdirs(dir));
        this.hostsFile = new Path(dir, "hosts");
        this.excludeFile = new Path(dir, "exclude");
        conf.set("dfs.hosts.exclude", this.excludeFile.toUri().getPath());
        conf.setInt("heartbeat.recheck.interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.replication.pending.timeout.sec", 4);
        this.writeConfigFile((FileSystem)localFileSys, this.excludeFile, null);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 6, true, null);
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, conf);
        DatanodeInfo[] info = client.datanodeReport(FSConstants.DatanodeReportType.LIVE);
        TestDecommission.assertEquals((String)"Number of Datanodes ", (int)6, (int)info.length);
        FileSystem fileSys = cluster.getFileSystem();
        try {
            for (int iteration = 0; iteration < 5; ++iteration) {
                int replicas = 6 - iteration - 1;
                Path file1 = new Path("decommission.dat");
                this.writeFile(fileSys, file1, replicas);
                System.out.println("Created file decommission.dat with " + replicas + " replicas.");
                this.checkFile(fileSys, file1, replicas);
                this.printFileLocations(fileSys, file1);
                String downnode = this.decommissionNode(cluster.getNameNode(), conf, client, (FileSystem)localFileSys);
                this.decommissionedNodes.add(downnode);
                this.waitNodeState(fileSys, downnode, NodeState.DECOMMISSIONED);
                this.checkFile(fileSys, file1, replicas, downnode);
                this.cleanupFile(fileSys, file1);
                this.cleanupFile((FileSystem)localFileSys, dir);
            }
        }
        catch (IOException e) {
            info = client.datanodeReport(FSConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    private static enum NodeState {
        NORMAL,
        DECOMMISSION_INPROGRESS,
        DECOMMISSIONED;

    }
}

