/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;

public class TestDatanodeReport
extends TestCase {
    private static final Configuration conf = new Configuration();
    private static final int NUM_OF_DATANODES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatanodeReport() throws Exception {
        conf.setInt("heartbeat.recheck.interval", 500);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 4, true, null);
        try {
            cluster.waitActive();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, conf);
            TestDatanodeReport.assertEquals((int)client.datanodeReport(FSConstants.DatanodeReportType.ALL).length, (int)4);
            TestDatanodeReport.assertEquals((int)client.datanodeReport(FSConstants.DatanodeReportType.LIVE).length, (int)4);
            TestDatanodeReport.assertEquals((int)client.datanodeReport(FSConstants.DatanodeReportType.DEAD).length, (int)0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            datanodes.remove(datanodes.size() - 1).shutdown();
            DatanodeInfo[] nodeInfo = client.datanodeReport(FSConstants.DatanodeReportType.DEAD);
            while (nodeInfo.length != 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                nodeInfo = client.datanodeReport(FSConstants.DatanodeReportType.DEAD);
            }
            TestDatanodeReport.assertEquals((int)client.datanodeReport(FSConstants.DatanodeReportType.LIVE).length, (int)3);
            TestDatanodeReport.assertEquals((int)client.datanodeReport(FSConstants.DatanodeReportType.ALL).length, (int)4);
        }
        finally {
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDatanodeReport().testDatanodeReport();
    }
}

