/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDFSClientRetries
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestDFSClientRetries.class.getName());

    private static void writeData(OutputStream out, int len) throws IOException {
        byte[] buf = new byte[65536];
        while (len > 0) {
            int toWrite = Math.min(len, buf.length);
            out.write(buf, 0, toWrite);
            len -= toWrite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteTimeoutAtDataNode() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        int writeTimeout = 100;
        conf.setInt("dfs.datanode.socket.write.timeout", 100);
        int blockSize = 0xA00000;
        conf.setInt("dfs.block.size", 0xA00000);
        conf.setInt("dfs.client.max.block.acquire.failures", 1);
        int bufferSize = 4096;
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteTimeoutAtDataNode");
            FSDataOutputStream out = fs.create(filePath, true, 4096);
            TestDFSClientRetries.writeData((OutputStream)out, 0x1400000);
            out.close();
            byte[] buf = new byte[0x100000];
            FSDataInputStream in = fs.open(filePath, 4096);
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)2048);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(200L);
                IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
            }
            in.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    public void testNotYetReplicatedErrors() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 1);
        TestNameNode tnn = new TestNameNode(conf);
        DFSClient client = new DFSClient(null, (ClientProtocol)tnn, conf, null);
        OutputStream os = client.create("testfile", true);
        os.write(20);
        try {
            os.close();
        }
        catch (Exception e) {
            TestDFSClientRetries.assertTrue((String)"Retries are not being stopped correctly", (boolean)e.getMessage().equals(tnn.ADD_BLOCK_EXCEPTION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailuresArePerOperation() throws Exception {
        long fileSize = 4096L;
        Path file = new Path("/testFile");
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        int maxBlockAcquires = DFSClient.getMaxBlockAcquireFailures((Configuration)conf);
        TestDFSClientRetries.assertTrue((maxBlockAcquires > 0 ? 1 : 0) != 0);
        try {
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            NameNode preSpyNN = cluster.getNameNode();
            NameNode spyNN = (NameNode)Mockito.spy((Object)preSpyNN);
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, conf, null);
            DFSTestUtil.createFile(fs, file, fileSize, (short)1, 12345L);
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires + 1)).when((Object)spyNN)).getBlockLocations(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
            try {
                IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                TestDFSClientRetries.fail((String)"Didn't get exception");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
            IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            DFSClient.LOG.info((Object)"Starting test case for failure reset");
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
            DFSClient.DFSInputStream is = client.open(file.toString());
            byte[] buf = new byte[10];
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            DFSClient.LOG.info((Object)"First read successful after some failures.");
            ((NameNode)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong());
            is.openInfo();
            is.seek(0L);
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static class FailNTimesAnswer
    implements Answer<LocatedBlocks> {
        private int failuresLeft;
        private NameNode realNN;

        public FailNTimesAnswer(NameNode realNN, int timesToFail) {
            this.failuresLeft = timesToFail;
            this.realNN = realNN;
        }

        public LocatedBlocks answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            LocatedBlocks realAnswer = this.realNN.getBlockLocations((String)args[0], ((Long)args[1]).longValue(), ((Long)args[2]).longValue());
            if (this.failuresLeft-- > 0) {
                NameNode.LOG.info((Object)"FailNTimesAnswer injecting failure.");
                return this.makeBadBlockList(realAnswer);
            }
            NameNode.LOG.info((Object)"FailNTimesAnswer no longer failing.");
            return realAnswer;
        }

        private LocatedBlocks makeBadBlockList(LocatedBlocks goodBlockList) {
            LocatedBlock goodLocatedBlock = goodBlockList.get(0);
            LocatedBlock badLocatedBlock = new LocatedBlock(goodLocatedBlock.getBlock(), new DatanodeInfo[]{new DatanodeInfo(new DatanodeID("255.255.255.255:234"))}, goodLocatedBlock.getStartOffset(), false);
            ArrayList<LocatedBlock> badBlocks = new ArrayList<LocatedBlock>();
            badBlocks.add(badLocatedBlock);
            return new LocatedBlocks(goodBlockList.getFileLength(), badBlocks, false);
        }
    }

    class TestNameNode
    implements ClientProtocol {
        int num_calls = 0;
        int num_calls_allowed;
        public final String ADD_BLOCK_EXCEPTION = "Testing exception thrown fromTestDFSClientRetries::TestNameNode::addBlock";
        public final String RETRY_CONFIG = "dfs.client.block.write.locateFollowingBlock.retries";

        public TestNameNode(Configuration conf) throws IOException {
            this.num_calls_allowed = conf.getInt("dfs.client.block.write.locateFollowingBlock.retries", 5) + 1;
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 41L;
        }

        public LocatedBlock addBlock(String src, String clientName) throws IOException {
            ++this.num_calls;
            if (this.num_calls > this.num_calls_allowed) {
                throw new IOException("addBlock called more times than dfs.client.block.write.locateFollowingBlock.retries allows.");
            }
            throw new RemoteException(NotReplicatedYetException.class.getName(), "Testing exception thrown fromTestDFSClientRetries::TestNameNode::addBlock");
        }

        public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
            return null;
        }

        public void create(String src, FsPermission masked, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        }

        public LocatedBlock append(String src, String clientName) throws IOException {
            return null;
        }

        public boolean setReplication(String src, short replication) throws IOException {
            return false;
        }

        public void setPermission(String src, FsPermission permission) throws IOException {
        }

        public void setOwner(String src, String username, String groupname) throws IOException {
        }

        public void abandonBlock(Block b, String src, String holder) throws IOException {
        }

        public boolean complete(String src, String clientName) throws IOException {
            return false;
        }

        public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        }

        public boolean rename(String src, String dst) throws IOException {
            return false;
        }

        public boolean delete(String src) throws IOException {
            return false;
        }

        public boolean delete(String src, boolean recursive) throws IOException {
            return false;
        }

        public boolean mkdirs(String src, FsPermission masked) throws IOException {
            return false;
        }

        public FileStatus[] getListing(String src) throws IOException {
            return null;
        }

        public void renewLease(String clientName) throws IOException {
        }

        public long[] getStats() throws IOException {
            return null;
        }

        public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType type) throws IOException {
            return null;
        }

        public long getPreferredBlockSize(String filename) throws IOException {
            return 0L;
        }

        public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
            return false;
        }

        public void saveNamespace() throws IOException {
        }

        public boolean restoreFailedStorage(String arg) throws AccessControlException {
            return false;
        }

        public void refreshNodes() throws IOException {
        }

        public void finalizeUpgrade() throws IOException {
        }

        public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
            return null;
        }

        public void metaSave(String filename) throws IOException {
        }

        public FileStatus getFileInfo(String src) throws IOException {
            return null;
        }

        public ContentSummary getContentSummary(String path) throws IOException {
            return null;
        }

        public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        }

        public void fsync(String src, String client) throws IOException {
        }

        public void setTimes(String src, long mtime, long atime) throws IOException {
        }
    }
}

