/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MiniDFSCluster {
    private Configuration conf;
    private NameNode nameNode;
    private int numDataNodes;
    private ArrayList<DataNodeProperties> dataNodes = new ArrayList();
    private File base_dir;
    private File data_dir;

    public MiniDFSCluster() {
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, HdfsConstants.StartupOption nameNodeOperation) throws IOException {
        this(0, conf, numDataNodes, false, false, false, nameNodeOperation, null, null, null);
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, null, null);
    }

    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks, String[] hosts) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, hosts, null);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, null);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageDataDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        String[] stringArray;
        this.conf = conf;
        try {
            UserGroupInformation.setCurrentUser((UserGroupInformation)UnixUserGroupInformation.login((Configuration)conf));
        }
        catch (LoginException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        this.base_dir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
        this.data_dir = new File(this.base_dir, "data");
        FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://localhost:" + Integer.toString(nameNodePort)));
        conf.set("dfs.http.address", "127.0.0.1:0");
        if (manageNameDfsDirs) {
            conf.set("dfs.name.dir", new File(this.base_dir, "name1").getPath() + "," + new File(this.base_dir, "name2").getPath());
            conf.set("fs.checkpoint.dir", new File(this.base_dir, "namesecondary1").getPath() + "," + new File(this.base_dir, "namesecondary2").getPath());
        }
        int replication = conf.getInt("dfs.replication", 3);
        conf.setInt("dfs.replication", Math.min(replication, numDataNodes));
        conf.setInt("dfs.safemode.extension", 0);
        conf.setInt("dfs.namenode.decommission.interval", 3);
        if (format) {
            if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
                throw new IOException("Cannot remove data directory: " + this.data_dir);
            }
            NameNode.format((Configuration)conf);
        }
        if (operation == null || operation == HdfsConstants.StartupOption.FORMAT || operation == HdfsConstants.StartupOption.REGULAR) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] args = stringArray;
        conf.setClass("topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
        this.nameNode = NameNode.createNameNode((String[])args, (Configuration)conf);
        this.startDataNodes(conf, numDataNodes, manageDataDfsDirs, operation, racks, hosts, simulatedCapacities);
        this.waitClusterUp();
    }

    public void waitClusterUp() {
        if (this.numDataNodes > 0) {
            while (!this.isClusterUp()) {
                try {
                    System.err.println("Waiting for the Mini HDFS Cluster to start...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        String[] stringArray;
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (this.nameNode != null) {
            InetSocketAddress nnAddr = this.nameNode.getNameNodeAddress();
            int nameNodePort = nnAddr.getPort();
            FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://" + nnAddr.getHostName() + ":" + Integer.toString(nameNodePort)));
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            System.out.println("Generating host names for datanodes");
            hosts = new String[numDataNodes];
            for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                hosts[i - curDatanodesNum] = "host" + i + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        conf.set("dfs.datanode.address", "127.0.0.1:0");
        conf.set("dfs.datanode.http.address", "127.0.0.1:0");
        conf.set("dfs.datanode.ipc.address", "127.0.0.1:0");
        if (operation == null || operation != HdfsConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            Configuration dnConf = new Configuration(conf);
            if (manageDfsDirs) {
                File dir1 = new File(this.data_dir, "data" + (2 * i + 1));
                File dir2 = new File(this.data_dir, "data" + (2 * i + 2));
                dir1.mkdirs();
                dir2.mkdirs();
                if (!dir1.isDirectory() || !dir2.isDirectory()) {
                    throw new IOException("Mkdirs failed to create directory for DataNode " + i + ": " + dir1 + " or " + dir2);
                }
                dnConf.set("dfs.data.dir", dir1.getPath() + "," + dir2.getPath());
            }
            if (simulatedCapacities != null) {
                dnConf.setBoolean("dfs.datanode.simulateddatastorage", true);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            System.out.println("Starting DataNode " + i + " with dfs.data.dir: " + dnConf.get("dfs.data.dir"));
            if (hosts != null) {
                dnConf.set("slave.host.name", hosts[i - curDatanodesNum]);
                System.out.println("Starting DataNode " + i + " with hostname set to: " + dnConf.get("slave.host.name"));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                System.out.println("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]);
                StaticMapping.addNodeToRack(name, racks[i - curDatanodesNum]);
            }
            Configuration newconf = new Configuration(dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            DataNode dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf);
            String ipAddr = dn.getSelfAddr().getAddress().getHostAddress();
            if (racks != null) {
                int port = dn.getSelfAddr().getPort();
                System.out.println("Adding node with IP:port : " + ipAddr + ":" + port + " to rack " + racks[i - curDatanodesNum]);
                StaticMapping.addNodeToRack(ipAddr + ":" + port, racks[i - curDatanodesNum]);
            }
            DataNode.runDatanodeDaemon((DataNode)dn);
            this.dataNodes.add(new DataNodeProperties(dn, newconf, dnArgs));
        }
        curDatanodesNum += numDataNodes;
        this.numDataNodes += numDataNodes;
        this.waitActive();
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    public void finalizeCluster(Configuration conf) throws Exception {
        if (this.nameNode == null) {
            throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
        }
        ToolRunner.run((Tool)new DFSAdmin(conf), (String[])new String[]{"-finalizeUpgrade"});
    }

    public NameNode getNameNode() {
        return this.nameNode;
    }

    public ArrayList<DataNode> getDataNodes() {
        ArrayList<DataNode> list = new ArrayList<DataNode>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode node = this.dataNodes.get((int)i).datanode;
            list.add(node);
        }
        return list;
    }

    public DataNode getDataNode(int ipcPort) {
        for (DataNode dn : this.getDataNodes()) {
            if (dn.ipcServer.getListenerAddress().getPort() != ipcPort) continue;
            return dn;
        }
        return null;
    }

    public int getNameNodePort() {
        return this.nameNode.getNameNodeAddress().getPort();
    }

    public void shutdown() {
        System.out.println("Shutting down the Mini HDFS Cluster");
        this.shutdownDataNodes();
        if (this.nameNode != null) {
            this.nameNode.stop();
            this.nameNode.join();
            this.nameNode = null;
        }
    }

    public void shutdownDataNodes() {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            System.out.println("Shutting down DataNode " + i);
            DataNode dn = this.dataNodes.remove((int)i).datanode;
            dn.shutdown();
            --this.numDataNodes;
        }
    }

    void corruptBlockOnDataNodes(String blockName) throws Exception {
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            this.corruptBlockOnDataNode(i, blockName);
        }
    }

    boolean corruptBlockOnDataNode(int i, String blockName) throws Exception {
        Random random = new Random();
        boolean corrupted = false;
        File dataDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/data");
        if (i < 0 || i >= this.dataNodes.size()) {
            return false;
        }
        for (int dn = i * 2; dn < i * 2 + 2; ++dn) {
            File blockFile = new File(dataDir, "data" + (dn + 1) + "/current/" + blockName);
            System.out.println("Corrupting for: " + blockFile);
            if (blockFile.exists()) {
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            corrupted = true;
        }
        return corrupted;
    }

    public DataNodeProperties stopDataNode(int i) {
        if (i < 0 || i >= this.dataNodes.size()) {
            return null;
        }
        DataNodeProperties dnprop = this.dataNodes.remove(i);
        DataNode dn = dnprop.datanode;
        System.out.println("MiniDFSCluster Stopping DataNode " + dn.dnRegistration.getName() + " from a total of " + (this.dataNodes.size() + 1) + " datanodes.");
        dn.shutdown();
        --this.numDataNodes;
        return dnprop;
    }

    public synchronized boolean restartDataNode(DataNodeProperties dnprop) throws IOException {
        Configuration conf = dnprop.conf;
        String[] args = dnprop.dnArgs;
        Configuration newconf = new Configuration(conf);
        this.dataNodes.add(new DataNodeProperties(DataNode.createDataNode((String[])args, (Configuration)conf), newconf, args));
        ++this.numDataNodes;
        return true;
    }

    public synchronized boolean restartDataNode(int i) throws IOException {
        DataNodeProperties dnprop = this.stopDataNode(i);
        if (dnprop == null) {
            return false;
        }
        return this.restartDataNode(dnprop);
    }

    public synchronized DataNodeProperties stopDataNode(String name) {
        int i;
        for (i = 0; i < this.dataNodes.size(); ++i) {
            DataNode dn = this.dataNodes.get((int)i).datanode;
            if (dn.dnRegistration.getName().equals(name)) break;
        }
        return this.stopDataNode(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterUp() {
        if (this.nameNode == null) {
            return false;
        }
        try {
            long[] sizes = this.nameNode.getStats();
            boolean isUp = false;
            MiniDFSCluster miniDFSCluster = this;
            synchronized (miniDFSCluster) {
                isUp = !this.nameNode.isInSafeMode() && sizes[0] != 0L;
            }
            return isUp;
        }
        catch (IOException ie) {
            return false;
        }
    }

    public boolean isDataNodeUp() {
        return this.dataNodes != null && this.dataNodes.size() != 0;
    }

    public FileSystem getFileSystem() throws IOException {
        return FileSystem.get((Configuration)this.conf);
    }

    public Collection<File> getNameDirs() {
        return FSNamesystem.getNamespaceDirs((Configuration)this.conf);
    }

    public Collection<File> getNameEditsDirs() {
        return FSNamesystem.getNamespaceEditsDirs((Configuration)this.conf);
    }

    public void waitActive() throws IOException {
        if (this.nameNode == null) {
            return;
        }
        InetSocketAddress addr = new InetSocketAddress("localhost", this.getNameNodePort());
        DFSClient client = new DFSClient(addr, this.conf);
        while (client.datanodeReport(FSConstants.DatanodeReportType.LIVE).length != this.numDataNodes) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        client.close();
    }

    public void formatDataNodeDirs() throws IOException {
        this.base_dir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
        this.data_dir = new File(this.base_dir, "data");
        if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
            throw new IOException("Cannot remove data directory: " + this.data_dir);
        }
    }

    public Block[] getBlockReport(int dataNodeIndex) {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.dataNodes.get((int)dataNodeIndex).datanode.getFSDataset().getBlockReport();
    }

    public Block[][] getAllBlockReports() {
        int numDataNodes = this.dataNodes.size();
        Block[][] result = new Block[numDataNodes][];
        for (int i = 0; i < numDataNodes; ++i) {
            result[i] = this.getBlockReport(i);
        }
        return result;
    }

    public void injectBlocks(int dataNodeIndex, Block[] blocksToInject) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        FSDatasetInterface dataSet = this.dataNodes.get((int)dataNodeIndex).datanode.getFSDataset();
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimilatedFSDataset");
        }
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleBlockReport(0L);
    }

    public void injectBlocks(Block[][] blocksToInject) throws IOException {
        if (blocksToInject.length > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < blocksToInject.length; ++i) {
            this.injectBlocks(i, blocksToInject[i]);
        }
    }

    void setLeasePeriod(long soft, long hard) {
        this.nameNode.namesystem.leaseManager.setLeasePeriod(soft, hard);
        this.nameNode.namesystem.lmthread.interrupt();
    }

    DataNode[] listDataNodes() {
        DataNode[] list = new DataNode[this.dataNodes.size()];
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            list[i] = this.dataNodes.get((int)i).datanode;
        }
        return list;
    }

    public String getDataDirectory() {
        return this.data_dir.getAbsolutePath();
    }

    public class DataNodeProperties {
        DataNode datanode;
        Configuration conf;
        String[] dnArgs;

        DataNodeProperties(DataNode node, Configuration conf, String[] args) {
            this.datanode = node;
            this.conf = conf;
            this.dnArgs = args;
        }
    }
}

