/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestHarFileSystem
extends TestCase {
    private Path inputPath;
    private MiniDFSCluster dfscluster;
    private MiniMRCluster mapred;
    private FileSystem fs;
    private Path filea;
    private Path fileb;
    private Path filec;
    private Path filed;
    private Path archivePath;

    protected void setUp() throws Exception {
        super.setUp();
        this.dfscluster = new MiniDFSCluster((Configuration)new JobConf(), 2, true, null);
        this.fs = this.dfscluster.getFileSystem();
        this.mapred = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        this.inputPath = new Path(this.fs.getHomeDirectory(), "test");
        this.filea = new Path(this.inputPath, "a");
        this.fileb = new Path(this.inputPath, "b");
        this.filec = new Path(this.inputPath, "c");
        this.filed = new Path(this.inputPath, "d%d");
        this.archivePath = new Path(this.fs.getHomeDirectory(), "tmp");
    }

    protected void tearDown() throws Exception {
        try {
            if (this.mapred != null) {
                this.mapred.shutdown();
            }
            if (this.dfscluster != null) {
                this.dfscluster.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        super.tearDown();
    }

    public void testArchives() throws Exception {
        this.fs.mkdirs(this.inputPath);
        FSDataOutputStream out = this.fs.create(this.filea);
        out.write("a".getBytes());
        out.close();
        out = this.fs.create(this.fileb);
        out.write("b".getBytes());
        out.close();
        out = this.fs.create(this.filec);
        out.write("c".getBytes());
        out.close();
        out = this.fs.create(this.filed);
        out.write("d".getBytes());
        out.close();
        JobConf conf = this.mapred.createJobConf();
        boolean archivecaching = conf.getBoolean("fs.har.impl.disable.cache", false);
        TestHarFileSystem.assertTrue((boolean)archivecaching);
        HadoopArchives har = new HadoopArchives((Configuration)conf);
        String[] args = new String[]{"-archiveName", "foo.har", this.inputPath.toString()};
        int ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args = new String[]{"-archiveName", "/d/foo.har", this.inputPath.toString(), this.archivePath.toString()};
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args[1] = "foo.har";
        args[3] = this.filec.toString();
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args[0] = "-archiveName";
        args[1] = "foo.har";
        args[2] = this.inputPath.toString();
        args[3] = this.archivePath.toString();
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        Path finalPath = new Path(this.archivePath, "foo.har");
        Path fsPath = new Path(this.inputPath.toUri().getPath());
        String relative = fsPath.toString().substring(1);
        Path filePath = new Path(finalPath, relative);
        Path harPath = new Path("har://" + filePath.toUri().getPath());
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_index")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_masterindex")));
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "_logs")) ? 1 : 0) != 0);
        FsShell shell = new FsShell((Configuration)conf);
        args = new String[]{"-ls", harPath.toString()};
        ret = ToolRunner.run((Tool)shell, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        Path harFilea = new Path(harPath, "a");
        Path harFileb = new Path(harPath, "b");
        Path harFilec = new Path(harPath, "c");
        Path harFiled = new Path(harPath, "d%d");
        FileSystem harFs = harFilea.getFileSystem((Configuration)conf);
        FSDataInputStream fin = harFs.open(harFilea);
        byte[] b = new byte[4];
        int readBytes = fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "a".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFileb);
        fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "b".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFilec);
        fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "c".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFiled);
        fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "d".getBytes()[0] ? 1 : 0) != 0);
        Path outdir = new Path(this.fs.getHomeDirectory(), "mapout");
        JobConf jobconf = this.mapred.createJobConf();
        FileInputFormat.addInputPath((JobConf)jobconf, (Path)harPath);
        jobconf.setInputFormat(TextInputFormat.class);
        jobconf.setOutputFormat(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)jobconf, (Path)outdir);
        jobconf.setMapperClass(TextMapperReducer.class);
        jobconf.setMapOutputKeyClass(Text.class);
        jobconf.setMapOutputValueClass(Text.class);
        jobconf.setReducerClass(TextMapperReducer.class);
        jobconf.setNumReduceTasks(1);
        JobClient.runJob((JobConf)jobconf);
        args[1] = outdir.toString();
        ret = ToolRunner.run((Tool)shell, (String[])args);
        FileStatus[] status = this.fs.globStatus(new Path(outdir, "part*"));
        Path reduceFile = status[0].getPath();
        FSDataInputStream reduceIn = this.fs.open(reduceFile);
        b = new byte[8];
        reduceIn.read(b);
        Text readTxt = new Text(b);
        TestHarFileSystem.assertTrue((boolean)"a\nb\nc\nd\n".equals(readTxt.toString()));
        TestHarFileSystem.assertTrue((String)"number of bytes left should be -1", (reduceIn.read(b) == -1 ? 1 : 0) != 0);
        reduceIn.close();
    }

    static class TextMapperReducer
    implements Mapper<LongWritable, Text, Text, Text>,
    Reducer<Text, Text, Text, Text> {
        TextMapperReducer() {
        }

        public void configure(JobConf conf) {
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            output.collect((Object)value, (Object)new Text(""));
        }

        public void close() throws IOException {
        }

        public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                values.next();
                output.collect((Object)key, null);
            }
        }
    }
}

