/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class IOMapperBase
extends Configured
implements Mapper<UTF8, LongWritable, UTF8, UTF8> {
    protected byte[] buffer;
    protected int bufferSize;
    protected FileSystem fs;
    protected String hostName;

    public IOMapperBase(Configuration conf) {
        super(conf);
        try {
            this.fs = FileSystem.get((Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create file system.", e);
        }
        this.bufferSize = conf.getInt("test.io.file.buffer.size", 4096);
        this.buffer = new byte[this.bufferSize];
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = "localhost";
        }
    }

    public void configure(JobConf job) {
        this.setConf((Configuration)job);
    }

    public void close() throws IOException {
    }

    abstract Object doIO(Reporter var1, String var2, long var3) throws IOException;

    abstract void collectStats(OutputCollector<UTF8, UTF8> var1, String var2, long var3, Object var5) throws IOException;

    public void map(UTF8 key, LongWritable value, OutputCollector<UTF8, UTF8> output, Reporter reporter) throws IOException {
        String name = key.toString();
        long longValue = value.get();
        reporter.setStatus("starting " + name + " ::host = " + this.hostName);
        long tStart = System.currentTimeMillis();
        Object statValue = this.doIO(reporter, name, longValue);
        long tEnd = System.currentTimeMillis();
        long execTime = tEnd - tStart;
        this.collectStats(output, name, execTime, statValue);
        reporter.setStatus("finished " + name + " ::host = " + this.hostName);
    }
}

