/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.TestDoAsEffectiveUser;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDelegationTokenForProxyUser {
    private static MiniDFSCluster cluster;
    private static Configuration config;
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES;
    private static final String REAL_USER = "RealUser";
    private static final String PROXY_USER = "ProxyUser";
    private static UserGroupInformation ugi;
    private static UserGroupInformation proxyUgi;
    private static final Log LOG;

    private static void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        config = new HdfsConfiguration();
        config.setBoolean("dfs.webhdfs.enabled", true);
        config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        config.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER), new String[]{GROUP1_NAME});
        config.setBoolean("dfs.namenode.delegation.token.always-use", true);
        TestDelegationTokenForProxyUser.configureSuperUserIPAddresses(config, REAL_USER);
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
        cluster = new MiniDFSCluster.Builder(config).build();
        cluster.waitActive();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        ugi = UserGroupInformation.createRemoteUser((String)REAL_USER);
        proxyUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER, (UserGroupInformation)ugi, (String[])GROUP_NAMES);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=20000L)
    public void testDelegationTokenWithRealUser() throws IOException {
        try {
            Token[] tokens = (Token[])proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<?>[]>(){

                @Override
                public Token<?>[] run() throws IOException {
                    return cluster.getFileSystem().addDelegationTokens("RenewerUser", null);
                }
            });
            DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
            byte[] tokenId = tokens[0].getIdentifier();
            identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
            Assert.assertEquals((Object)identifier.getUser().getUserName(), (Object)PROXY_USER);
            Assert.assertEquals((Object)identifier.getUser().getRealUser().getUserName(), (Object)REAL_USER);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test(timeout=20000L)
    public void testWebHdfsDoAs() throws Exception {
        WebHdfsTestUtil.LOG.info((Object)"START: testWebHdfsDoAs()");
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)ExceptionHandler.LOG).getLogger().setLevel(Level.ALL);
        WebHdfsTestUtil.LOG.info((Object)("ugi.getShortUserName()=" + ugi.getShortUserName()));
        WebHdfsFileSystem webhdfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, config);
        Path root = new Path("/");
        cluster.getFileSystem().setPermission(root, new FsPermission(511));
        URL url = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(PROXY_USER)});
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map<?, ?> m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        conn.disconnect();
        Object responsePath = m.get(Path.class.getSimpleName());
        WebHdfsTestUtil.LOG.info((Object)("responsePath=" + responsePath));
        Assert.assertEquals((Object)"/user/ProxyUser", responsePath);
        url = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(PROXY_USER){

            public String getName() {
                return "DOas";
            }
        }});
        conn = (HttpURLConnection)url.openConnection();
        m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        conn.disconnect();
        responsePath = m.get(Path.class.getSimpleName());
        WebHdfsTestUtil.LOG.info((Object)("responsePath=" + responsePath));
        Assert.assertEquals((Object)"/user/ProxyUser", responsePath);
        Path f = new Path("/testWebHdfsDoAs/a.txt");
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        URL url2 = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)op, f, new Param[]{new DoAsParam(PROXY_USER)});
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2 = WebHdfsTestUtil.twoStepWrite(webhdfs, (HttpOpParam.Op)op, conn2);
        FSDataOutputStream out = WebHdfsTestUtil.write(webhdfs, (HttpOpParam.Op)op, conn2, 4096);
        out.write("Hello, webhdfs user!".getBytes());
        out.close();
        FileStatus status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
        op = PostOpParam.Op.APPEND;
        url2 = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)op, f, new Param[]{new DoAsParam(PROXY_USER)});
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2 = WebHdfsTestUtil.twoStepWrite(webhdfs, (HttpOpParam.Op)op, conn2);
        out = WebHdfsTestUtil.write(webhdfs, (HttpOpParam.Op)op, conn2, 4096);
        out.write("\nHello again!".getBytes());
        out.close();
        status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        WebHdfsTestUtil.LOG.info((Object)("status.getLen()  =" + status.getLen()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
    }

    static {
        GROUP_NAMES = new String[]{GROUP1_NAME, GROUP2_NAME};
        LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);
    }
}

