/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSBuilder;
import org.apache.hadoop.fs.impl.WrappedIOException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FutureIOSupport {
    private FutureIOSupport() {
    }

    public static <T> T awaitFuture(Future<T> future) throws InterruptedIOException, IOException, RuntimeException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIOSupport.raiseInnerCause(e);
        }
    }

    public static <T> T awaitFuture(Future<T> future, long timeout, TimeUnit unit) throws InterruptedIOException, IOException, RuntimeException, TimeoutException {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIOSupport.raiseInnerCause(e);
        }
    }

    public static <T> T raiseInnerCause(ExecutionException e) throws IOException {
        throw FutureIOSupport.unwrapInnerException(e);
    }

    public static <T> T raiseInnerCause(CompletionException e) throws IOException {
        throw FutureIOSupport.unwrapInnerException(e);
    }

    private static IOException unwrapInnerException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof WrappedIOException) {
            return ((WrappedIOException)cause).getCause();
        }
        if (cause instanceof CompletionException) {
            return FutureIOSupport.unwrapInnerException(cause);
        }
        if (cause instanceof ExecutionException) {
            return FutureIOSupport.unwrapInnerException(cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause != null) {
            return new IOException(cause);
        }
        return new IOException(e);
    }

    public static <T, U extends FSBuilder<T, U>> FSBuilder<T, U> propagateOptions(FSBuilder<T, U> builder, Configuration conf, String optionalPrefix, String mandatoryPrefix) {
        FutureIOSupport.propagateOptions(builder, conf, optionalPrefix, false);
        FutureIOSupport.propagateOptions(builder, conf, mandatoryPrefix, true);
        return builder;
    }

    public static void propagateOptions(FSBuilder<?, ?> builder, Configuration conf, String prefix, boolean mandatory) {
        String p = prefix.endsWith(".") ? prefix : prefix + ".";
        Map<String, String> propsWithPrefix = conf.getPropsWithPrefix(p);
        for (Map.Entry<String, String> entry : propsWithPrefix.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (mandatory) {
                builder.must(key, val);
                continue;
            }
            builder.opt(key, val);
        }
    }
}

