/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJvmMetrics {
    @Test
    public void testPresence() {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)new JvmMetrics("test", "test"));
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (info.name().startsWith("Mem")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyFloat());
                continue;
            }
            if (info.name().startsWith("Gc")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
                continue;
            }
            if (info.name().startsWith("Threads")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
                continue;
            }
            if (!info.name().startsWith("Log")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
        }
    }
}

