/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.junit.Assert;
import org.junit.Test;

public class TestSigner {
    @Test
    public void testNoSecret() throws Exception {
        try {
            new Signer(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullAndEmptyString() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        try {
            signer.sign(null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            signer.sign("");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    @Test
    public void testSignature() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String s1 = signer.sign("ok");
        String s2 = signer.sign("ok");
        String s3 = signer.sign("wrong");
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotSame((Object)s1, (Object)s3);
    }

    @Test
    public void testVerify() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String t = "test";
        String s = signer.sign(t);
        String e = signer.verifyAndExtract(s);
        Assert.assertEquals((Object)t, (Object)e);
    }

    @Test
    public void testInvalidSignedText() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        try {
            signer.verifyAndExtract("test");
            Assert.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    @Test
    public void testTampering() throws Exception {
        Signer signer = new Signer("secret".getBytes());
        String t = "test";
        String s = signer.sign(t);
        s = s + "x";
        try {
            signer.verifyAndExtract(s);
            Assert.fail();
        }
        catch (SignerException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }
}

