/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class CompareRequest
extends LdapMessage {
    private LdapDN entry;
    private String attributeDesc;
    private Object assertionValue;
    private transient int compareRequestLength;
    private transient int avaLength;

    public int getMessageType() {
        return 5;
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public Object getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(Object assertionValue) {
        this.assertionValue = assertionValue;
    }

    public String getAttributeDesc() {
        return this.attributeDesc == null ? "" : this.attributeDesc;
    }

    public void setAttributeDesc(String attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public int computeLength() {
        this.compareRequestLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.entry)) + LdapDN.getNbBytes(this.entry);
        int attributeDescLength = StringTools.getBytesUtf8(this.attributeDesc).length;
        this.avaLength = 1 + TLV.getNbBytes((int)attributeDescLength) + attributeDescLength;
        if (this.assertionValue instanceof String) {
            int assertionValueLength = StringTools.getBytesUtf8((String)this.assertionValue).length;
            this.avaLength += 1 + TLV.getNbBytes((int)assertionValueLength) + assertionValueLength;
        } else {
            this.avaLength += 1 + TLV.getNbBytes((int)((byte[])this.assertionValue).length) + ((byte[])this.assertionValue).length;
        }
        this.compareRequestLength += 1 + TLV.getNbBytes((int)this.avaLength) + this.avaLength;
        return 1 + TLV.getNbBytes((int)this.compareRequestLength) + this.compareRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes((int)this.compareRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.entry));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (String)this.attributeDesc);
        if (this.assertionValue instanceof String) {
            Value.encode((ByteBuffer)buffer, (String)((String)this.assertionValue));
        } else {
            Value.encode((ByteBuffer)buffer, (byte[])((byte[])this.assertionValue));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        Attribute description : '").append(this.attributeDesc).append("'\n");
        sb.append("        Attribute value : '").append(StringTools.dumpObject(this.assertionValue)).append("'\n");
        return sb.toString();
    }
}

