/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.directory.shared.ldap.aci.Permission;
import org.apache.directory.shared.ldap.aci.UserClass;

public class ItemPermission
extends Permission {
    private static final long serialVersionUID = 3940100745409337694L;
    private final Collection userClasses;

    public ItemPermission(int precedence, Collection grantsAndDenials, Collection userClasses) {
        super(precedence, grantsAndDenials);
        Iterator i = userClasses.iterator();
        while (i.hasNext()) {
            Object val = i.next();
            if (val instanceof UserClass) continue;
            throw new IllegalArgumentException("userClasses contains a wrong element.");
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList(userClasses));
    }

    public Collection getUserClasses() {
        return this.userClasses;
    }

    public String toString() {
        return "itemPermission: precedence=" + this.getPrecedence() + ", " + "userClasses=" + this.userClasses + ", " + "grantsAndDenials=" + this.getGrantsAndDenials();
    }
}

