/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeDescAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(AttributeDescAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public AttributeDescAction() {
        super("Store attribute description");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        String attributeDescription = null;
        if (tlv.getLength() != 0 && !StringTools.isEmpty((attributeDescription = StringTools.utf8ToString(tlv.getValue().getData())).trim())) {
            searchRequest.addAttribute(attributeDescription);
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            log.debug("Decoded Attribute Description : {}", (Object)attributeDescription);
        }
    }
}

