/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.name.RdnSerializer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDNSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapDNSerializer.class);

    public static void serialize(LdapDN dn, ObjectOutput out) throws IOException {
        if (dn.getUpName() == null) {
            String message = "Cannot serialize a NULL DN";
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(dn.getUpName());
        if (dn.isNormalized()) {
            if (dn.getUpName().equals(dn.getNormName())) {
                out.writeUTF("");
            } else {
                out.writeUTF(dn.getNormName());
            }
        } else {
            String message = "The DN should have been normalized before being serialized " + dn;
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeInt(dn.size());
        for (Rdn rdn : dn.getRdns()) {
            RdnSerializer.serialize(rdn, out);
        }
    }

    public static LdapDN deserialize(ObjectInput in) throws IOException {
        String upName = in.readUTF();
        String normName = in.readUTF();
        if (normName.length() == 0) {
            normName = upName;
        }
        byte[] bytes = StringTools.getBytesUtf8(upName);
        int nbRdns = in.readInt();
        LdapDN dn = new LdapDN(upName, normName, bytes);
        for (int i = 0; i < nbRdns; ++i) {
            Rdn rdn = RdnSerializer.deserialize(in);
            dn.add(0, rdn);
        }
        return dn;
    }
}

