/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncDoneValueControlCodec
extends AbstractAsn1Object {
    private byte[] cookie;
    private boolean refreshDeletes;
    private int syncDoneValueLength;

    public int computeLength() {
        if (this.cookie != null) {
            this.syncDoneValueLength = 1 + TLV.getNbBytes((int)this.cookie.length) + this.cookie.length;
        }
        this.syncDoneValueLength += 3;
        return 1 + TLV.getNbBytes((int)this.syncDoneValueLength) + this.syncDoneValueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes((int)this.syncDoneValueLength));
        if (this.cookie != null) {
            Value.encode((ByteBuffer)bb, (byte[])this.cookie);
        }
        Value.encode((ByteBuffer)bb, (boolean)this.refreshDeletes);
        return bb;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncDoneValue control :\n");
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        sb.append("        refreshDeletes : '").append(this.refreshDeletes).append("'\n");
        return sb.toString();
    }
}

