/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.InternalModifyDnResponse;
import org.apache.directory.shared.ldap.message.InternalResultResponse;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;

public class ModifyDnRequestImpl
extends AbstractAbandonableRequest
implements InternalModifyDnRequest {
    static final long serialVersionUID = 1233507339633051696L;
    private LdapDN name;
    private Rdn newRdn;
    private LdapDN newSuperior;
    private boolean deleteOldRdn = false;
    private InternalModifyDnResponse response;

    public ModifyDnRequestImpl(int id) {
        super(id, TYPE);
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public boolean isMove() {
        return this.newSuperior != null;
    }

    public LdapDN getName() {
        return this.name;
    }

    public void setName(LdapDN name) {
        this.name = name;
    }

    public Rdn getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(Rdn newRdn) {
        this.newRdn = newRdn;
    }

    public LdapDN getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(LdapDN newSuperior) {
        this.newSuperior = newSuperior;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyDnResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalModifyDnRequest req = (InternalModifyDnRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (this.deleteOldRdn != req.getDeleteOldRdn()) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() == null) {
            return false;
        }
        if (this.newRdn == null && req.getNewRdn() != null) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() != null && !this.newRdn.equals(req.getNewRdn())) {
            return false;
        }
        if (this.newSuperior != null && req.getNewSuperior() == null) {
            return false;
        }
        if (this.newSuperior == null && req.getNewSuperior() != null) {
            return false;
        }
        return this.newSuperior == null || req.getNewSuperior() == null || this.newSuperior.equals(req.getNewSuperior());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.name).append("'\n");
        sb.append("        New RDN : '").append(this.newRdn.toString()).append("'\n");
        sb.append("        Delete old RDN : ").append(this.deleteOldRdn).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior.toString()).append("'\n");
        }
        return sb.toString();
    }
}

