/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import org.apache.directory.shared.asn1.ber.AbstractContainer;
import org.apache.directory.shared.ldap.codec.ControlCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageGrammar;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;

public class LdapMessageContainer
extends AbstractContainer {
    private LdapMessageCodec ldapMessage;
    private final BinaryAttributeDetector binaryAttributeDetector;
    private int messageId;
    private ControlCodec currentControl;

    public LdapMessageContainer() {
        this(new BinaryAttributeDetector(){

            public boolean isBinary(String attributeId) {
                return false;
            }
        });
    }

    public LdapMessageContainer(BinaryAttributeDetector binaryAttributeDetector) {
        this.stateStack = new int[10];
        this.grammar = LdapMessageGrammar.getInstance();
        this.states = LdapStatesEnum.getInstance();
        this.binaryAttributeDetector = binaryAttributeDetector;
    }

    public LdapMessageCodec getLdapMessage() {
        return this.ldapMessage;
    }

    public void setLdapMessage(LdapMessageCodec ldapMessage) {
        this.ldapMessage = ldapMessage;
    }

    public void clean() {
        super.clean();
        this.ldapMessage = null;
        this.messageId = 0;
        this.currentControl = null;
        this.decodeBytes = 0;
    }

    public boolean isBinary(String id) {
        return this.binaryAttributeDetector.isBinary(id);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public ControlCodec getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(ControlCodec currentControl) {
        this.currentControl = currentControl;
    }
}

