/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringCursor
extends AbstractIndexCursor<String, ServerEntry> {
    private static final String UNSUPPORTED_MSG = "SubstringCursors may not be ordered and do not support positioning by element.";
    private final boolean hasIndex;
    private final IndexCursor<String, ServerEntry> wrapped;
    private final SubstringEvaluator evaluator;
    private final ForwardIndexEntry<String, ServerEntry> indexEntry = new ForwardIndexEntry();
    private boolean available = false;

    public SubstringCursor(Store<ServerEntry> db, SubstringEvaluator substringEvaluator) throws Exception {
        this.evaluator = substringEvaluator;
        this.hasIndex = db.hasUserIndexOn(this.evaluator.getExpression().getAttribute());
        this.wrapped = this.hasIndex ? db.getUserIndex(this.evaluator.getExpression().getAttribute()).forwardCursor() : db.getNdnIndex().forwardCursor();
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(Long id, String value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(Long id, String value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void before(IndexEntry<String, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void after(IndexEntry<String, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.evaluator.getExpression().getInitial() != null && this.hasIndex) {
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setValue(this.evaluator.getExpression().getInitial());
            this.wrapped.before((ServerEntry)((Object)indexEntry));
        } else {
            this.wrapped.beforeFirst();
        }
        this.clear();
    }

    private void clear() {
        this.available = false;
        this.indexEntry.setObject(null);
        this.indexEntry.setId(null);
        this.indexEntry.setValue(null);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clear();
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    private boolean evaluateCandidate(IndexEntry<String, ServerEntry> indexEntry) throws Exception {
        if (this.hasIndex) {
            return this.evaluator.getPattern().matcher(indexEntry.getValue()).matches();
        }
        return this.evaluator.evaluate(indexEntry);
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.available = true;
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setValue((String)entry.getValue());
            this.indexEntry.setObject((ServerEntry)entry.getObject());
            return true;
        }
        this.clear();
        return false;
    }

    @Override
    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.available = true;
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setValue((String)entry.getValue());
            this.indexEntry.setObject((ServerEntry)entry.getObject());
            return true;
        }
        this.clear();
        return false;
    }

    @Override
    public IndexEntry<String, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return this.indexEntry;
        }
        throw new InvalidCursorPositionException("Cursor has yet to be positioned.");
    }

    @Override
    public boolean isElementReused() {
        return this.wrapped.isElementReused();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.wrapped.close();
        this.clear();
    }
}

