/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.MetaSchemaUtils;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaChangeHandler
implements SchemaChangeHandler {
    protected final Registries targetRegistries;
    protected final PartitionSchemaLoader loader;
    protected final AttributeType m_oidAT;
    protected final SchemaEntityFactory factory;

    protected AbstractSchemaChangeHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws Exception {
        this.targetRegistries = targetRegistries;
        this.loader = loader;
        this.m_oidAT = targetRegistries.getAttributeTypeRegistry().lookup("m-oid");
        this.factory = new SchemaEntityFactory(targetRegistries);
    }

    protected void checkOidIsUnique(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected void checkOidIsUnique(SchemaObject schemaObject) throws Exception {
        String oid = schemaObject.getOid();
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected void checkOidIsUnique(String oid) throws Exception {
        if (this.targetRegistries.getOidRegistry().hasOid(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema entity is not unique.", ResultCodeEnum.OTHER);
        }
    }

    protected abstract boolean modify(LdapDN var1, ServerEntry var2, ServerEntry var3, boolean var4) throws Exception;

    @Override
    public final boolean modify(LdapDN name, ModificationOperation modOp, ServerEntry mods, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        return this.modify(name, entry, targetEntry, cascade);
    }

    @Override
    public final boolean modify(LdapDN name, List<Modification> mods, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        return this.modify(name, entry, targetEntry, cascade);
    }

    protected Set<String> getOids(Set<ServerEntry> results) throws Exception {
        HashSet<String> oids = new HashSet<String>(results.size());
        for (ServerEntry result : results) {
            LdapDN dn = result.getDn();
            dn.normalize(this.targetRegistries.getAttributeTypeRegistry().getNormalizerMapping());
            oids.add((String)dn.getRdn().getValue());
        }
        return oids;
    }

    protected String getOid(ServerEntry entry) throws Exception {
        EntryAttribute oid = entry.get(this.m_oidAT);
        if (oid == null) {
            return null;
        }
        return oid.getString();
    }

    protected String getSchemaName(LdapDN name) throws Exception {
        return MetaSchemaUtils.getSchemaName(name);
    }

    protected Schema getSchema(LdapDN name) throws Exception {
        return this.loader.getSchema(MetaSchemaUtils.getSchemaName(name));
    }

    protected void unregisterOids(String oid) throws Exception {
        this.targetRegistries.getOidRegistry().unregister(oid);
    }

    protected void registerOids(SchemaObject obj) throws Exception {
        String[] names = obj.getNamesRef();
        if (names != null) {
            for (String name : names) {
                this.targetRegistries.getOidRegistry().register(name, obj.getOid());
            }
        }
        this.targetRegistries.getOidRegistry().register(obj.getOid(), obj.getOid());
    }
}

