/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributesPropertyEditor
extends PropertyEditorSupport {
    public AttributesPropertyEditor() {
    }

    public AttributesPropertyEditor(Object source) {
        super(source);
    }

    public String getAsText() {
        Attributes attrs = (Attributes)this.getValue();
        try {
            return LdifUtils.convertToLdif(attrs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Entry readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        DefaultClientEntry entry = new DefaultClientEntry();
        block6: while (true) {
            try {
                while ((line = in.readLine()) != null) {
                    String addedLine;
                    if (line.length() == 0 || StringTools.isEmpty(addedLine = line.trim())) continue;
                    EntryAttribute attribute = AttributeUtils.toClientAttribute(LdifReader.parseAttributeValue(addedLine));
                    EntryAttribute oldAttribute = entry.get(attribute.getId());
                    if (oldAttribute != null) {
                        try {
                            oldAttribute.add(attribute.get());
                            entry.put(oldAttribute);
                            continue block6;
                        }
                        catch (NamingException ne) {
                            continue;
                        }
                    }
                    try {
                        entry.put(attribute);
                        continue block6;
                    }
                    catch (NamingException ne) {
                    }
                }
                break;
            }
            catch (IOException ioe) {
                // empty catch block
                break;
            }
        }
        return entry;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            text = "";
        }
        Entry entry = this.readEntry(text);
        this.setValue(entry);
    }
}

