/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.ldif.LdifEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogEvent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String zuluTime;
    private long revision;
    private LdifEntry forwardLdif;
    private List<LdifEntry> reverseLdifs;
    private LdapPrincipal committer;

    public ChangeLogEvent() {
    }

    public ChangeLogEvent(long revision, String zuluTime, LdapPrincipal committer, LdifEntry forwardLdif, LdifEntry reverseLdif) {
        this.zuluTime = zuluTime;
        this.revision = revision;
        this.forwardLdif = forwardLdif;
        this.reverseLdifs = new ArrayList<LdifEntry>(1);
        this.reverseLdifs.add(reverseLdif);
        this.committer = committer;
    }

    public ChangeLogEvent(long revision, String zuluTime, LdapPrincipal committer, LdifEntry forwardLdif, List<LdifEntry> reverseLdifs) {
        this.zuluTime = zuluTime;
        this.revision = revision;
        this.forwardLdif = forwardLdif;
        this.reverseLdifs = reverseLdifs;
        this.committer = committer;
    }

    public LdifEntry getForwardLdif() {
        return this.forwardLdif;
    }

    public List<LdifEntry> getReverseLdifs() {
        return this.reverseLdifs;
    }

    public LdapPrincipal getCommitterPrincipal() {
        return this.committer;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getZuluTime() {
        return this.zuluTime;
    }

    public EntryAttribute get(String attributeName) {
        return this.forwardLdif.get(attributeName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbReverseLdif;
        boolean hasForwardLdif;
        this.committer = (LdapPrincipal)in.readObject();
        this.revision = in.readLong();
        boolean hasZuluTime = in.readBoolean();
        if (hasZuluTime) {
            this.zuluTime = in.readUTF();
        }
        if (hasForwardLdif = in.readBoolean()) {
            this.forwardLdif = (LdifEntry)in.readObject();
        }
        if ((nbReverseLdif = in.readInt()) > 0) {
            this.reverseLdifs = new ArrayList<LdifEntry>(nbReverseLdif);
            for (int i = 0; i < nbReverseLdif; ++i) {
                this.reverseLdifs.add((LdifEntry)in.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.committer);
        out.writeLong(this.revision);
        if (this.zuluTime != null) {
            out.writeBoolean(true);
            out.writeUTF(this.zuluTime);
        } else {
            out.writeBoolean(false);
        }
        if (this.forwardLdif != null) {
            out.writeBoolean(true);
            out.writeObject(this.forwardLdif);
        } else {
            out.writeBoolean(false);
        }
        if (this.reverseLdifs != null) {
            out.writeInt(this.reverseLdifs.size());
            for (LdifEntry reverseLdif : this.reverseLdifs) {
                out.writeObject(reverseLdif);
            }
        } else {
            out.writeBoolean(false);
        }
        out.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeLogEvent { ");
        sb.append("principal=").append(this.getCommitterPrincipal()).append(", ");
        sb.append("zuluTime=").append(this.getZuluTime()).append(", ");
        sb.append("revision=").append(this.getRevision()).append(", ");
        sb.append("\nforwardLdif=").append(this.getForwardLdif()).append(", ");
        if (this.reverseLdifs != null) {
            sb.append("\nreverseLdif number=").append(this.reverseLdifs.size());
            int i = 0;
            for (LdifEntry reverseLdif : this.reverseLdifs) {
                sb.append("\nReverse[").append(i++).append("] :\n");
                sb.append(reverseLdif);
            }
        }
        sb.append(" }");
        return sb.toString();
    }
}

