/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class TokenInputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenInputStream.class);
    private final String[] tokens;
    private int pos;

    public TokenInputStream(String[] t) {
        this.tokens = t;
    }

    public String read() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Reading token " + this.tokens[this.pos]);
        }
        return this.tokens[this.pos++];
    }

    public String readNext() {
        return this.read(this.pos++);
    }

    public String read(int position) {
        if (position < 0) {
            this.pos = 0;
        }
        if (position > this.tokens.length) {
            this.pos = this.tokens.length - 1;
        }
        return this.tokens[this.pos];
    }

    public String readPre() {
        if (this.pos != 0) {
            --this.pos;
        }
        return this.tokens[this.pos];
    }

    public String peek() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Peeking token " + this.tokens[this.pos]);
        }
        return this.tokens[this.pos];
    }

    public String peekPre() {
        if (this.pos == 0) {
            return this.tokens[this.pos];
        }
        return this.tokens[this.pos - 1];
    }

    public String peek(int position) {
        if (position < 0) {
            return this.tokens[0];
        }
        if (position > this.tokens.length) {
            return this.tokens[this.tokens.length - 1];
        }
        return this.tokens[position];
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int p) {
        this.pos = p;
    }

    public int available() {
        return this.tokens.length - this.pos;
    }

    public boolean hasNext() {
        return this.available() > 1;
    }

    public boolean isOutOfBound() {
        return this.pos >= this.tokens.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        for (int i = this.pos; i < this.tokens.length; ++i) {
            sb.append(this.tokens[i]);
            if (i >= this.tokens.length - 1) continue;
            sb.append(" ");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

