/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.autoconfigure.ssl;

import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.spring.boot.autoconfigure.ssl.CxfClientSslProperties;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

final class SslBundleHttpConduitConfigurer
implements HTTPConduitConfigurer {
    private final SslBundles sslBundles;
    private final CxfClientSslProperties props;
    private final AntPathMatcher matcher = new AntPathMatcher();

    SslBundleHttpConduitConfigurer(SslBundles sslBundles, CxfClientSslProperties props) {
        this.sslBundles = Objects.requireNonNull(sslBundles, "sslBundles");
        this.props = Objects.requireNonNull(props, "props");
    }

    public void configure(String name, String address, HTTPConduit conduit) {
        String bundleName;
        CxfClientSslProperties.CxfClientSslBundle cxfClientSslBundle = this.findMatchCxfClientSslBundle(address, this.props.getCxfClientSslBundles());
        String string = bundleName = cxfClientSslBundle != null ? cxfClientSslBundle.getBundle() : this.props.getDefaultBundle();
        if (!StringUtils.hasText((String)bundleName)) {
            return;
        }
        SslBundle bundle = this.sslBundles.getBundle(bundleName);
        TLSClientParameters tls = this.buildTls(bundle, cxfClientSslBundle);
        conduit.setTlsClientParameters(tls);
    }

    private TLSClientParameters buildTls(SslBundle bundle, CxfClientSslProperties.CxfClientSslBundle cxfClientSslBundle) {
        SSLContext ctx = bundle.createSslContext();
        TLSClientParameters tls = new TLSClientParameters();
        tls.setSslContext(ctx);
        if (cxfClientSslBundle != null && StringUtils.hasText((String)cxfClientSslBundle.getProtocol())) {
            tls.setSecureSocketProtocol(cxfClientSslBundle.getProtocol());
        }
        if (cxfClientSslBundle != null && cxfClientSslBundle.getCipherSuites() != null && !cxfClientSslBundle.getCipherSuites().isEmpty()) {
            tls.setCipherSuites(cxfClientSslBundle.getCipherSuites());
        }
        if (cxfClientSslBundle != null) {
            tls.setDisableCNCheck(cxfClientSslBundle.getDisableCnCheck().booleanValue());
        } else {
            tls.setDisableCNCheck(this.props.getDisableCnCheck().booleanValue());
        }
        return tls;
    }

    private CxfClientSslProperties.CxfClientSslBundle findMatchCxfClientSslBundle(String address, List<CxfClientSslProperties.CxfClientSslBundle> cxfClientSslBundles) {
        if (!StringUtils.hasText((String)address) || cxfClientSslBundles == null) {
            return null;
        }
        for (CxfClientSslProperties.CxfClientSslBundle r : cxfClientSslBundles) {
            String pat = r.getAddress();
            if (!StringUtils.hasText((String)pat)) continue;
            if (SslBundleHttpConduitConfigurer.isPrefix(pat) && address.startsWith(pat)) {
                return r;
            }
            if (!SslBundleHttpConduitConfigurer.isAntStyle(pat) || !this.matcher.match(pat, address)) continue;
            return r;
        }
        return null;
    }

    private static boolean isPrefix(String p) {
        return p.startsWith("http://") || p.startsWith("https://");
    }

    private static boolean isAntStyle(String p) {
        return p.contains("*") || p.contains("?");
    }
}

